/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.state_listeners;

import be.iminds.ilabt.jfed.highlevel.jobs.SingleTaskJob;
import be.iminds.ilabt.jfed.highlevel.jobs.StateFinishedListener;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateSliceTask;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterExperimentStateListener
implements StateFinishedListener<SingleTaskJob.ExecuteTaskState> {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterExperimentStateListener.class);

    public void onStateFinished(SingleTaskJob.ExecuteTaskState state) {
        if (((CreateSliceTask)state.getTask()).getSlice() == null) {
            LOG.error("Create Slice task failed. (createSliceTask.getSlice() == null)");
            boolean isDuplicateSliceError = false;
            if (state.getTaskExecution().getException() instanceof JFedException) {
                JFedException ex = (JFedException)state.getTaskExecution().getException();
                if (ex.getXmlRpcReply() != null && ex.getXmlRpcReply().getOutput() != null && ex.getXmlRpcReply().getOutput().endsWith(" already a registered slice")) {
                    isDuplicateSliceError = true;
                    LOG.warn("Detected that exception of register experiment is a duplicate slice error");
                } else {
                    LOG.warn("Received an unrecognized other error: {}", (Object)(ex.getXmlRpcReply() != null ? ex.getXmlRpcReply().getOutput() : "null"));
                }
            }
            if (isDuplicateSliceError) {
                Platform.runLater(() -> JFDialogs.create().message("The experiment name that you requested is already in use on the slice authority. Please try again with another name.\n\nCheck the Errors-tab for more information.").masthead("Experiment name already in use").title("Experiment registration failed").showError());
            } else {
                Platform.runLater(() -> JFDialogs.create().message("An error occurred when requesting the slice credential.\n\n.Check the Errors-tab for more information.").masthead("Experiment registration failed").title("Experiment registration failed").showError());
            }
        }
    }
}

