/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.state_listeners;

import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.highlevel.jobs.StateFinishedListener;
import be.iminds.ilabt.jfed.highlevel.jobs.TestConnectivityJob;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConnectivityToExperimentPartsStateListener
implements StateFinishedListener<TestConnectivityJob.TestConnectivityToExperimentPartsState> {
    private static final Logger LOG = LoggerFactory.getLogger(TestConnectivityToExperimentPartsStateListener.class);
    private final JFedPreferences jFedPreferences;
    private final BrowserUtil browserUtil;
    private final BugReportDialogFactory bugReportDialogFactory;

    public TestConnectivityToExperimentPartsStateListener(JFedPreferences jFedPreferences, BrowserUtil browserUtil, BugReportDialogFactory bugReportDialogFactory) {
        this.jFedPreferences = jFedPreferences;
        this.browserUtil = browserUtil;
        this.bugReportDialogFactory = bugReportDialogFactory;
    }

    public void onStateFinished(TestConnectivityJob.TestConnectivityToExperimentPartsState state) {
        List failedNodes = state.getFailedNodes();
        if (!failedNodes.isEmpty()) {
            if (this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_CONNECTIVITY_WARNING_DIALOG, true)) {
                LOG.debug("Showing connectivity warning dialog");
                VBox pane = new VBox();
                pane.setSpacing(20.0);
                Text introText = new Text(String.format("jFed detected that node(s) %s cannot be reached.\nYou can take the following steps to resolve the problem:\n\n", failedNodes.stream().map(FXRspecNode::getClientId).collect(Collectors.joining(", "))));
                introText.setStyle("-fx-font-weight: bold");
                Hyperlink text1 = new Hyperlink("1. Try enabling the proxy for SSH connections\n");
                text1.setOnAction(actionEvent -> this.browserUtil.openUrlInBrowser("http://doc.ilabt.iminds.be/jfed-documentation-5.9/advancedfeatures.html#proxy-settings"));
                Hyperlink text2 = new Hyperlink("2. Check the support forum");
                text2.setOnAction(actionEvent -> this.browserUtil.openUrlInBrowser("http://doc.fed4fire.eu/support.html"));
                Hyperlink text3 = new Hyperlink("3. Request assistance by submitting a bug report");
                text3.setOnAction(actionEvent -> this.bugReportDialogFactory.showDialog());
                TextFlow errorMessageTextFlow = new TextFlow(new Node[]{introText, text1, new Text("\n"), text2, new Text("\n"), text3});
                pane.getChildren().add((Object)errorMessageTextFlow);
                CheckBox checkBox = new CheckBox("Do not show this dialog again");
                pane.getChildren().add((Object)checkBox);
                DialogPane dialogPane = new DialogPane();
                dialogPane.setHeaderText("Experiment connectivity issues");
                dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PLAY, (Color)Color.GREEN));
                dialogPane.setContent((Node)pane);
                dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
                Dialog dialog = new Dialog();
                dialog.setTitle("Experiment connectivity issues");
                dialog.setDialogPane(dialogPane);
                dialog.showAndWait();
                this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_CONNECTIVITY_WARNING_DIALOG, !checkBox.isSelected());
            } else {
                LOG.debug("Skipping connectivity issues dialog because user muted it before");
            }
        }
    }
}

