/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSlicesTask;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

public class FetchAllSlicesInfoTask
extends javafx.concurrent.Task<Void> {
    private final SfaModel sfaModel;
    private final HighLevelTaskFactory hltf;
    private final TaskThread tt;

    public FetchAllSlicesInfoTask(SfaModel sfaModel, HighLevelTaskFactory hltf, TaskThread tt) {
        this.sfaModel = sfaModel;
        this.hltf = hltf;
        this.tt = tt;
    }

    protected Void call() throws Exception {
        this.updateMessage("Fetching all existing experiments");
        ListSlicesTask refreshSlicesTask = this.hltf.listSlices();
        TaskExecution refreshTaskExecution = this.hltf.submitTask((Task)refreshSlicesTask);
        while (!refreshTaskExecution.isCompleted()) {
            Thread.sleep(100L);
        }
        this.updateMessage(String.format("Received %d experiments", refreshSlicesTask.getSlices().size()));
        List extraTasks = this.sfaModel.getSlices().stream().filter(slice -> slice.getExpirationDate() == null).map(arg_0 -> ((HighLevelTaskFactory)this.hltf).getAggregatesForSlice(arg_0)).collect(Collectors.toList());
        if (!extraTasks.isEmpty()) {
            this.updateMessage(String.format("Received %d experiments. Requesting extra info.", refreshSlicesTask.getSlices().size()));
            CountDownLatch latch = new CountDownLatch(extraTasks.size());
            for (Task extraTask : extraTasks) {
                this.tt.addTask(extraTask, (task1, taskExecution, state) -> {
                    latch.countDown();
                    this.updateMessage(String.format("Received %d experiments. Requesting extra info (%d left).", refreshSlicesTask.getSlices().size(), latch.getCount()));
                });
            }
            latch.await();
        }
        return null;
    }
}

