/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tasks;

import be.iminds.ilabt.jfed.espec.bundle.AbstractArchiveESpecBundle;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.parser.ExperimentSpecificationParser;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenESpecEvent;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.io.IOException;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenESpecTask
extends Task<ESpecBundle> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenESpecTask.class);
    private final Stage ownerStage = null;
    @Nonnull
    private final OpenESpecEvent openESpecEvent;
    @Nonnull
    private final JFedPreferences jFedPreferences;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final DialogsFactory dialogsFactory;
    @Nonnull
    private final RSpecGeneratorFactory rSpecGeneratorFactory;

    OpenESpecTask(@Nonnull OpenESpecEvent openESpecEvent, @Nonnull JFedPreferences jFedPreferences, @Nonnull GeniUserProvider geniUserProvider, @Nonnull DialogsFactory dialogsFactory, @Nonnull RSpecGeneratorFactory rSpecGeneratorFactory) {
        this.openESpecEvent = openESpecEvent;
        this.jFedPreferences = jFedPreferences;
        this.geniUserProvider = geniUserProvider;
        this.dialogsFactory = dialogsFactory;
        this.rSpecGeneratorFactory = rSpecGeneratorFactory;
        this.updateTitle("Fetching ExperimentSpecification '" + String.valueOf(openESpecEvent) + "'");
    }

    protected ESpecBundle call() {
        try {
            ESpecBundle eSpecBundle = this.openESpecEvent.getEspecBundle(this.jFedPreferences, this.geniUserProvider);
            ExperimentSpecification eSpec = eSpecBundle.getExperimentSpecification();
            return eSpecBundle;
        }
        catch (InterruptedException e) {
            LOG.error("Got interrupted while fetching ESpecBundle", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() != null && e.getCause() instanceof ExperimentSpecificationParser.ExperimentSpecificationParseException) {
                ExperimentSpecificationParser.ExperimentSpecificationParseException cause = (ExperimentSpecificationParser.ExperimentSpecificationParseException)e.getCause();
                Platform.runLater(() -> JFDialogs.create().owner((Window)this.ownerStage).title("Parsing ExperimentSpecification failed").masthead("Parsing ExperimentSpecification failed").message("Error: " + cause.getMessage()).showError());
                LOG.debug("Showed parse error to user", (Throwable)cause);
                return null;
            }
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                IOException cause = (IOException)e.getCause();
                Platform.runLater(() -> JFDialogs.create().owner((Window)this.ownerStage).title("Opening ExperimentSpecification I/O Error").masthead("Opening ExperimentSpecification I/O Error").message("IO Error: " + cause.getMessage()).showError());
                return null;
            }
            Platform.runLater(() -> JFDialogs.create().owner((Window)this.ownerStage).title("Opening ExperimentSpecification failed").masthead("Opening ExperimentSpecification failed").message("An IllegalArgumentException occurred while opening ExperimentSpecification: " + e.getMessage()).showException((Throwable)e));
            LOG.error("Something is wrong with the ESpecBundle", (Throwable)e);
            return null;
        }
        catch (AbstractArchiveESpecBundle.ESpecBundleInvalidArchiveException e) {
            LOG.error("Got an ESpecBundleInvalidArchiveException while fetching ESpecBundle", (Throwable)e);
            Platform.runLater(() -> JFDialogs.create().owner((Window)this.ownerStage).title("Bad Archive").masthead("Bad Archive").message("Problem opening ESpec archive. Make sure you select a .zip, .tar.gz or .tgz or other archive. (To open a \"experiment-specification.yaml\" file, use source \"Local Directory\")").showException((Throwable)e));
            return null;
        }
        catch (ESpecBundle.ESpecBundleInitException e) {
            LOG.error("Got an ESpecBundleInitException while fetching ESpecBundle", (Throwable)e);
            Platform.runLater(() -> JFDialogs.create().owner((Window)this.ownerStage).title("Opening ExperimentSpecification failed").masthead("Opening ExperimentSpecification failed").message("An error occurred while opening ExperimentSpecification: " + e.getMessage()).showException((Throwable)e));
            return null;
        }
    }

    protected void failed() {
        LOG.warn("An error occurred while opening ExperimentSpecification: " + this.getMessage(), this.getException());
        JFDialogs.create().owner((Window)this.ownerStage).title("Opening ExperimentSpecification failed").masthead("Opening ExperimentSpecification failed").message("An error occurred while opening ExperimentSpecification: " + this.getMessage()).showException(this.getException());
        super.failed();
    }

    protected void succeeded() {
        LOG.info("Successfully opened ExperimentSpecification Bundle");
        ESpecBundle eSpecBundle = (ESpecBundle)this.getValue();
        if (eSpecBundle != null) {
            if (this.openESpecEvent.getExperimentController() == null) {
                this.dialogsFactory.showCreateSliceDialog(null, eSpecBundle);
            } else {
                this.openESpecEvent.getExperimentController().getExperiment().resetExperimentSpecification(eSpecBundle.getExperimentSpecification(), eSpecBundle, this.rSpecGeneratorFactory, this.jFedPreferences.getGitAuthPreferences(this.geniUserProvider.getLoggedInGeniUser()));
                this.openESpecEvent.getExperimentController().getExperiment().getExperimentSpecificationFileManager().fetchAll();
                this.openESpecEvent.getExperimentController().rerunESpec(null, null);
            }
        }
    }
}

