/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tasks;

import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTabFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationEngine;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ExperimentEditorTabHost;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.stage.Window;

public class OpenRequestRspecFromStringTask
extends Task<EditableRspec> {
    private final Window parentWindow;
    private final String requestRspec;
    private final ExperimentEditorTabFactory experimentEditorTabFactory;
    private final ExperimentEditorTabHost experimentEditorTabHost;
    private final RspecValidationEngine validationEngine = new RspecValidationEngine();

    OpenRequestRspecFromStringTask(Window parentWindow, String requestRspec, ExperimentEditorTabFactory experimentEditorTabFactory, ExperimentEditorTabHost experimentEditorTabHost) {
        this.parentWindow = parentWindow;
        this.requestRspec = requestRspec;
        this.experimentEditorTabFactory = experimentEditorTabFactory;
        this.experimentEditorTabHost = experimentEditorTabHost;
        this.updateTitle("Parsing request Rspec");
    }

    protected EditableRspec call() throws Exception {
        ImmutableRequestRspecSource requestRspecSource = new ImmutableRequestRspecSource(this.requestRspec, ModelRspecType.FX);
        FutureTask<RspecValidationResult> verifyCall = new FutureTask<RspecValidationResult>(() -> this.lambda$call$0((RequestRspecSource)requestRspecSource));
        Platform.runLater(verifyCall);
        RspecValidationResult verifyRspecResult = (RspecValidationResult)verifyCall.get();
        Object resultRspecSource = verifyRspecResult != null ? verifyRspecResult.getReplacementRequestRspecSource() : requestRspecSource;
        if (!resultRspecSource.isLosingData(ModelRspecType.FX)) {
            ModelRspec modelRspec = resultRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
            if (modelRspec == null) {
                throw new IllegalStateException("jFed bug: FX modelrspec is not losing data, yet it is null (should never happen)");
            }
            resultRspecSource = new ImmutableRequestRspecSource(modelRspec);
        }
        return new EditableRspec((RequestRspecSource)resultRspecSource, "request.rspec", null);
    }

    protected void succeeded() {
        ExperimentEditorTab newTab = this.experimentEditorTabFactory.createExperimentEditorTab((EditableRspec)this.getValue());
        this.experimentEditorTabHost.addExperimentEditorTab(newTab);
        this.experimentEditorTabHost.showExperimentEditorTab(newTab);
    }

    protected void failed() {
        if (this.getException() instanceof RspecParseException) {
            RspecParseException ex = (RspecParseException)this.getException();
            JFDialogs.create().owner(this.parentWindow).message("The specified source does not contain a valid Rspec.\n\n" + (String)(ex.getStaxLocation() == null ? "" : "Error on line " + ex.getStaxLocation().getLineNumber() + ", column " + ex.getStaxLocation().getColumnNumber()) + ": " + ex.getMessage()).masthead("Opening Rspec failed").title("Opening Rspec failed").showException((Throwable)ex);
        } else {
            JFDialogs.create().owner(this.parentWindow).message("Could not open the RSpec from the given source: " + this.getException().getMessage()).masthead("Error while opening Experiment Definition").title("Error while opening Experiment Definition").showException(this.getException());
        }
    }

    private /* synthetic */ RspecValidationResult lambda$call$0(RequestRspecSource requestRspecSource) throws Exception {
        return this.validationEngine.validateRSpec(RspecCheckReason.OPENED_FILE, requestRspecSource, this.parentWindow);
    }
}

