/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tasks;

import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTabFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationEngine;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ExperimentEditorTabHost;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenRequestRspecTask
extends Task<EditableRspec> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenRequestRspecTask.class);
    private static final double READ_PROGRESS_PART = 0.25;
    private static final double PARSE_PROGRESS_PART = 0.75;
    private final Window parentWindow;
    private final Source source;
    private final ExperimentEditorTabFactory experimentEditorTabFactory;
    private final ExperimentEditorTabHost experimentEditorTabHost;
    private final RspecValidationEngine validationEngine = new RspecValidationEngine();

    OpenRequestRspecTask(Window parentWindow, final File file, ExperimentEditorTabFactory experimentEditorTabFactory, ExperimentEditorTabHost experimentEditorTabHost) {
        this.parentWindow = parentWindow;
        this.experimentEditorTabFactory = experimentEditorTabFactory;
        this.experimentEditorTabHost = experimentEditorTabHost;
        this.updateTitle("Loading request Rspec file '" + file.getName() + "'");
        this.source = new Source(){
            private FileInputStream fis = null;

            @Override
            public void open() throws IOException {
                this.fis = new FileInputStream(file);
            }

            @Override
            public void close() throws IOException {
                if (this.fis != null) {
                    this.fis.close();
                }
            }

            @Override
            public InputStream getInputStream() {
                return this.fis;
            }

            @Override
            public Long getLength() {
                return file.length();
            }

            @Override
            public String getName() {
                return file.getName().replace(".rspec", "");
            }

            @Override
            public File getDefaultSaveFile() {
                return file;
            }
        };
    }

    OpenRequestRspecTask(Window parentWindow, final InputStream inputStream, final long fileLength, final String name, final File defaultSaveFile, ExperimentEditorTabFactory experimentEditorTabFactory, ExperimentEditorTabHost experimentEditorTabHost) {
        this.parentWindow = parentWindow;
        this.experimentEditorTabFactory = experimentEditorTabFactory;
        this.experimentEditorTabHost = experimentEditorTabHost;
        this.updateTitle("Loading request Rspec '" + name + "'");
        this.source = new Source(){

            @Override
            public void open() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public InputStream getInputStream() {
                return inputStream;
            }

            @Override
            public Long getLength() {
                return fileLength;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public File getDefaultSaveFile() {
                return defaultSaveFile;
            }
        };
    }

    OpenRequestRspecTask(Window parentWindow, final String urlString, ExperimentEditorTabFactory experimentEditorTabFactory, ExperimentEditorTabHost experimentEditorTabHost) {
        this.parentWindow = parentWindow;
        this.experimentEditorTabFactory = experimentEditorTabFactory;
        this.experimentEditorTabHost = experimentEditorTabHost;
        final String name = urlString.substring(urlString.lastIndexOf(47) + 1).replace(".rspec", "");
        this.source = new Source(){
            private URL url;
            private HttpURLConnection conn;

            @Override
            public void open() throws IOException {
                this.url = new URL(urlString);
                this.conn = (HttpURLConnection)this.url.openConnection();
            }

            @Override
            public void close() throws IOException {
                if (this.conn != null) {
                    this.conn.disconnect();
                }
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return this.conn.getInputStream();
            }

            @Override
            public Long getLength() {
                return this.conn.getContentLengthLong();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public File getDefaultSaveFile() {
                return null;
            }
        };
        this.updateTitle("Loading request Rspec '" + name + "'");
    }

    protected EditableRspec call() throws Exception {
        this.source.open();
        StringBuilder fileContents = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(this.source.getInputStream());){
            int count;
            int readingProgress = 0;
            char[] cbuf = new char[1024];
            while ((count = reader.read(cbuf)) != -1) {
                fileContents.append(cbuf, 0, count);
                readingProgress += count;
                if (this.source.getLength() != null) {
                    this.updateProgress(0.25 * (double)readingProgress / (double)this.source.getLength().longValue(), 1.0);
                    continue;
                }
                this.updateProgress(-1.0, 0.0);
            }
        }
        this.source.close();
        ImmutableRequestRspecSource requestRspecSource = new ImmutableRequestRspecSource(fileContents.toString(), ModelRspecType.FX);
        FutureTask<RspecValidationResult> verifyCall = new FutureTask<RspecValidationResult>(() -> this.lambda$call$0((RequestRspecSource)requestRspecSource));
        Platform.runLater(verifyCall);
        RspecValidationResult verifyRspecResult = (RspecValidationResult)verifyCall.get();
        Object resultRspecSource = verifyRspecResult != null ? verifyRspecResult.getReplacementRequestRspecSource() : requestRspecSource;
        if (!resultRspecSource.isLosingData(ModelRspecType.FX)) {
            ModelRspec modelRspec = resultRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
            if (modelRspec == null) {
                throw new IllegalStateException("jFed bug: FX modelrspec is not losing data, yet it is null (should never happen)");
            }
            resultRspecSource = new ImmutableRequestRspecSource(modelRspec);
        }
        return new EditableRspec((RequestRspecSource)resultRspecSource, this.source.getName(), this.source.getDefaultSaveFile());
    }

    protected void succeeded() {
        ExperimentEditorTab newTab = this.experimentEditorTabFactory.createExperimentEditorTab((EditableRspec)this.getValue());
        this.experimentEditorTabHost.addExperimentEditorTab(newTab);
        this.experimentEditorTabHost.showExperimentEditorTab(newTab);
    }

    protected void failed() {
        if (this.getException() instanceof RspecParseException) {
            RspecParseException ex = (RspecParseException)this.getException();
            JFDialogs.create().owner(this.parentWindow).message("The specified source does not contain a valid Rspec.\n\n" + (String)(ex.getStaxLocation() == null ? "" : "Error on line " + ex.getStaxLocation().getLineNumber() + ", column " + ex.getStaxLocation().getColumnNumber()) + ": " + ex.getMessage()).masthead("Opening Rspec failed").title("Opening Rspec failed").showException((Throwable)ex);
        } else {
            JFDialogs.create().owner(this.parentWindow).message("Could not open the RSpec from the given source: " + this.getException().getMessage()).masthead("Error while opening Experiment Definition").title("Error while opening Experiment Definition").showException(this.getException());
        }
    }

    public String getName() {
        return this.source.getName();
    }

    private /* synthetic */ RspecValidationResult lambda$call$0(RequestRspecSource requestRspecSource) throws Exception {
        return this.validationEngine.validateRSpec(RspecCheckReason.OPENED_FILE, requestRspecSource, this.parentWindow);
    }

    private static interface Source {
        public void open() throws IOException;

        public void close() throws IOException;

        public InputStream getInputStream() throws IOException;

        public Long getLength();

        public String getName();

        public File getDefaultSaveFile();
    }
}

