/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tasks;

import be.iminds.ilabt.jfed.experimenter_gui.tutorials.Tutorial;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.TutorialViewsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.Tutorials;
import be.iminds.ilabt.jfed.experimenter_gui.util.ProgressMonitorInputStream;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import javafx.concurrent.Task;
import javafx.stage.Window;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.controlsfx.dialog.ExceptionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTutorialTask
extends Task<Tutorials> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTutorialTask.class);
    private static final double READ_PROGRESS_PART = 0.25;
    private static final double PARSE_PROGRESS_PART = 0.75;
    private final Window parentWindow;
    private final InputStream inputStream;
    private final long fileLength;
    private final String name;
    private final TutorialViewsFactory tutorialViewsFactory;
    private final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    OpenTutorialTask(Window parentWindow, File file, TutorialViewsFactory tutorialViewsFactory) throws FileNotFoundException {
        this.parentWindow = parentWindow;
        this.tutorialViewsFactory = tutorialViewsFactory;
        this.updateTitle("Loading tutorial '" + file.getName() + "'");
        this.inputStream = new FileInputStream(file);
        this.fileLength = file.length();
        this.name = file.getName().replace(".rspec", "");
    }

    OpenTutorialTask(Window parentWindow, InputStream inputStream, long fileLength, String name, TutorialViewsFactory tutorialViewsFactory) {
        this.parentWindow = parentWindow;
        this.tutorialViewsFactory = tutorialViewsFactory;
        this.updateTitle("Loading request Rspec '" + name + "'");
        this.inputStream = inputStream;
        this.fileLength = fileLength;
        this.name = name;
    }

    OpenTutorialTask(Window parentWindow, String urlString, TutorialViewsFactory tutorialViewsFactory) throws IOException {
        this.parentWindow = parentWindow;
        this.tutorialViewsFactory = tutorialViewsFactory;
        URL url = new URL(urlString);
        String name = urlString.substring(urlString.lastIndexOf(47) + 1);
        this.name = name = name.replace(".rspec", "");
        this.updateTitle("Loading request Rspec '" + name + "'");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        this.inputStream = url.openStream();
        this.fileLength = conn.getContentLengthLong();
    }

    protected Tutorials call() throws IOException, TutorialParseException {
        ProgressMonitorInputStream monitoredInputStream = new ProgressMonitorInputStream(new BufferedInputStream(this.inputStream, 500000));
        monitoredInputStream.mark(500000);
        monitoredInputStream.nreadProperty().addListener(observable -> this.updateProgress(monitoredInputStream.getNread(), monitoredInputStream.getSize()));
        XmlMapper mapper = new XmlMapper();
        mapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
                LOG.warn("Encountered an unknown property {} while deserializing {} (position: {}, {})", new Object[]{propertyName, beanOrClass.toString(), jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr()});
                return true;
            }
        });
        String rootName = null;
        try {
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(monitoredInputStream);
            if (!reader.hasNext()) {
                throw new TutorialParseException("Given file seems to be invalid");
            }
            reader.next();
            rootName = reader.getLocalName();
            reader.close();
        }
        catch (XMLStreamException ex) {
            throw new TutorialParseException("Exception while reading tutorial file: " + ex.getMessage(), ex);
        }
        monitoredInputStream.reset();
        if (Objects.equals("f4ftuts", rootName)) {
            return (Tutorials)mapper.readValue((InputStream)monitoredInputStream, Tutorials.class);
        }
        if (Objects.equals("f4ftut", rootName)) {
            Tutorials result = new Tutorials();
            Tutorial tutorial = (Tutorial)mapper.readValue((InputStream)monitoredInputStream, Tutorial.class);
            result.setTutorials(Collections.singletonList(tutorial));
            return result;
        }
        throw new TutorialParseException("Unexpected type of root element: " + rootName);
    }

    protected void succeeded() {
        this.tutorialViewsFactory.createTutorialsView((Tutorials)this.getValue()).showDialog();
    }

    protected void failed() {
        if (this.getException() instanceof JsonParseException) {
            JsonParseException ex = (JsonParseException)this.getException();
            ExceptionDialog dialog = new ExceptionDialog((Throwable)ex);
            dialog.initOwner(this.parentWindow);
            dialog.setContentText("The specified source does not contain a valid tutorial file.\n\nError on line " + ex.getLocation().getLineNr() + ", column " + ex.getLocation().getColumnNr() + ": " + ex.getMessage());
            dialog.setHeaderText("Opening Tutorial failed");
            dialog.setTitle("Opening Tutorial failed");
            dialog.showAndWait();
        } else {
            ExceptionDialog dialog = new ExceptionDialog(this.getException());
            dialog.initOwner(this.parentWindow);
            dialog.setContentText("Could not open the tutorial from the given source: " + this.getException().getMessage());
            dialog.setHeaderText("Error while opening Tutorial");
            dialog.setTitle("Error while opening Tutorial");
            dialog.showAndWait();
        }
    }

    public String getName() {
        return this.name;
    }

    public static final class TutorialParseException
    extends Exception {
        public TutorialParseException() {
        }

        public TutorialParseException(String message) {
            super(message);
        }

        public TutorialParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public TutorialParseException(Throwable cause) {
            super(cause);
        }

        public TutorialParseException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

