/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tasks;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.SelectAuthoritiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.events.RecoverExperimentEvent;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTaskInteraction;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverSliceTaskGuiInteraction
implements RecoverSliceTaskInteraction {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverSliceTaskGuiInteraction.class);
    @Nonnull
    private final Provider<SelectAuthoritiesDialog> selectAuthoritiesDialogProvider;
    @Nonnull
    private final EventBus eventBus;
    @Nullable
    private final Stage ownerStage;

    public RecoverSliceTaskGuiInteraction(@Nonnull Provider<SelectAuthoritiesDialog> selectAuthoritiesDialogProvider, @Nonnull EventBus eventBus, @Nullable Stage ownerStage) {
        this.selectAuthoritiesDialogProvider = selectAuthoritiesDialogProvider;
        this.eventBus = eventBus;
        this.ownerStage = ownerStage;
    }

    public void onCouldNotRetrieve(@Nullable Throwable exception) {
        Platform.runLater(() -> {
            JFDialogs d = JFDialogs.create().owner((Window)this.ownerStage).title("Could not retrieve shared experiment").masthead("Could not retrieve shared experiment").message("The given experiment could not be found on the server. Please check the provided URN!");
            if (LOG.isDebugEnabled() && exception != null) {
                d.showException(exception);
            }
            d.showError();
        });
    }

    public void onUnknownAuthoritiesDetected(@Nonnull String sliceName, @Nonnull List<GeniUrn> unknownAuthorities) throws InterruptedException {
        FutureTask<Void> dialogTask = new FutureTask<Void>(() -> {
            JFDialogs.create().owner((Window)this.ownerStage).title("Unknown authorities detected").masthead("Unknown authorities detected").message(String.format("The slice '%s' that you are recovering contains one or more unknown authorities (%s).\njFed cannot recover resources from authorities it does not know. The recovery can thus be incomplete.\n\nSubmit a bugreport to contact support.", sliceName, unknownAuthorities.stream().map(GeniUrn::toString).collect(Collectors.joining(", ")))).showWarning();
            return null;
        });
        Platform.runLater(dialogTask);
        while (!dialogTask.isDone()) {
            Thread.sleep(100L);
        }
    }

    public boolean onNoActiveResources(@Nonnull String sliceName) throws InterruptedException {
        ButtonType selectManualButton = new ButtonType("Select manually", ButtonBar.ButtonData.YES);
        FutureTask<Optional> dialogTask = new FutureTask<Optional>(() -> {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("No active resources found");
            alert.setHeaderText("No active resources found");
            alert.setContentText(String.format("There are currently no active resources registered at your authority for '%s'.\nIf you are sure there are active resources, please manually select the involved testbeds in the next step.", sliceName));
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            alert.setResizable(true);
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{selectManualButton, ButtonType.CANCEL});
            return alert.showAndWait();
        });
        Platform.runLater(dialogTask);
        while (!dialogTask.isDone()) {
            Thread.sleep(100L);
        }
        try {
            LOG.debug("User answer on slice recovery question: {}", (Object)dialogTask.get());
            if (dialogTask.get().orElse(ButtonType.CANCEL) == selectManualButton) {
                return true;
            }
            LOG.debug("User cancelled slice recovery");
            return false;
        }
        catch (ExecutionException e) {
            LOG.error("ExecutionException while handling slice recovery question answer for " + sliceName, (Throwable)e);
            return false;
        }
    }

    @Nonnull
    public Optional<Set<Server>> requestAuthorities() throws InterruptedException {
        FutureTask<Optional> showSelectAuthoritiesDialogTask = new FutureTask<Optional>(() -> {
            try {
                return ((SelectAuthoritiesDialog)((Object)((Object)this.selectAuthoritiesDialogProvider.get()))).showAndWait();
            }
            catch (AssertionError | Exception t) {
                LOG.error("Exception in showSelectAuthoritiesDialogTask", (Throwable)t);
                return Optional.empty();
            }
        });
        Platform.runLater(showSelectAuthoritiesDialogTask);
        try {
            return showSelectAuthoritiesDialogTask.get();
        }
        catch (ExecutionException e) {
            LOG.error("ExecutionException while handling result of showSelectAuthoritiesDialogTask", (Throwable)e);
            return Optional.empty();
        }
    }

    public void onCouldNotFindInfoWhenUserSelected(@Nonnull String sliceName) throws InterruptedException {
        FutureTask<Object> dialogTask = new FutureTask<Object>(() -> JFDialogs.create().owner((Window)this.ownerStage).message(String.format("Could not find information about %s on the selected testbeds. Please verify that you selected the correct testbeds and try again.", sliceName)).masthead("Could not retrieve shared experiment").title("Could not retrieve shared experiment").showWarning(), null);
        Platform.runLater(dialogTask);
        try {
            dialogTask.get();
        }
        catch (ExecutionException ex) {
            LOG.error("Error while showing information dialog", (Throwable)ex);
        }
    }

    private static String serversToString(@Nullable Collection<Server> servers) {
        if (servers == null) {
            return "null";
        }
        return servers.stream().map(Server::getName).collect(Collectors.toList()).toString();
    }

    public void onCouldNotFindInfoWhenAutoSelected(@Nonnull String sliceName, @Nonnull Set<Server> allInvolvedAuthorities) {
        Platform.runLater(() -> JFDialogs.create().owner((Window)this.ownerStage).message(String.format("Could not find information about %s on the involved testbeds: %s Please manually select testbeds and try again.", sliceName, RecoverSliceTaskGuiInteraction.serversToString(allInvolvedAuthorities))).masthead("Could not retrieve shared experiment").title("Could not retrieve shared experiment").showWarning());
    }

    public void onFinalFailed(@Nonnull String sliceName, @Nullable String message, @Nullable Throwable exception) {
        JFDialogs.create().owner((Window)this.ownerStage).title("Recovering experiment failed").masthead("Recovering experiment failed").message("An error occurred while recovering experiment '" + sliceName + "': " + message).showException(exception);
    }

    public void onFinalSucces(@Nonnull Experiment experiment) {
        this.eventBus.post((Object)new RecoverExperimentEvent(experiment));
    }
}

