/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tasks;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.SelectAuthoritiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTabFactory;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenESpecEvent;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.DeleteDiskImageTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.FetchAllSlicesInfoTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.OpenESpecTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.OpenRequestRspecFromStringTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.OpenRequestRspecTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.OpenTutorialTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.RecoverSliceTaskGuiInteraction;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.TasksFactory;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.TutorialViewsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ExperimentEditorTabHost;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTaskInteraction;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javafx.concurrent.Task;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class TasksFactoryImpl
implements TasksFactory {
    private final SfaModel sfaModel;
    private final HighLevelTaskFactory hltf;
    private final TaskThread tt;
    private final EventBus eventBus;
    private final Provider<SelectAuthoritiesDialog> selectAuthoritiesDialogProvider;
    private final Provider<TutorialViewsFactory> tutorialViewsFactoryProvider;
    private final ExperimentEditorTabFactory experimentEditorTabFactory;
    private final ExperimentEditorTabHost experimentEditorTabHost;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final JFedPreferences jFedPreferences;
    private final DialogsFactory dialogsFactory;
    private final GeniUserProvider geniUserProvider;
    private final RSpecGeneratorFactory rSpecGeneratorFactory;

    @Inject
    TasksFactoryImpl(SfaModel sfaModel, HighLevelTaskFactory hltf, TaskThread tt, EventBus eventBus, Provider<TutorialViewsFactory> tutorialViewsFactoryProvider, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, JFedPreferences jFedPreferences, Provider<SelectAuthoritiesDialog> selectAuthoritiesDialogProvider, ExperimentEditorTabFactory experimentEditorTabFactory, ExperimentEditorTabHost experimentEditorTabHost, GeniUserProvider geniUserProvider, DialogsFactory dialogsFactory, RSpecGeneratorFactory rSpecGeneratorFactory) {
        this.sfaModel = sfaModel;
        this.hltf = hltf;
        this.tt = tt;
        this.eventBus = eventBus;
        this.tutorialViewsFactoryProvider = tutorialViewsFactoryProvider;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.jFedPreferences = jFedPreferences;
        this.selectAuthoritiesDialogProvider = selectAuthoritiesDialogProvider;
        this.experimentEditorTabFactory = experimentEditorTabFactory;
        this.experimentEditorTabHost = experimentEditorTabHost;
        this.dialogsFactory = dialogsFactory;
        this.geniUserProvider = geniUserProvider;
        this.rSpecGeneratorFactory = rSpecGeneratorFactory;
    }

    @Override
    @Nonnull
    public RecoverSliceTask createRecoverSliceTask(@Nonnull GeniUrn sliceUrn) {
        RecoverSliceTaskGuiInteraction guiInteraction = new RecoverSliceTaskGuiInteraction(this.selectAuthoritiesDialogProvider, this.eventBus, null);
        return this.hltf.createRecoverSliceTask(sliceUrn, (RecoverSliceTaskInteraction)guiInteraction);
    }

    @Override
    @Nonnull
    public RecoverSliceTask createRecoverSliceTask(@Nonnull Slice slice) {
        RecoverSliceTaskGuiInteraction guiInteraction = new RecoverSliceTaskGuiInteraction(this.selectAuthoritiesDialogProvider, this.eventBus, null);
        return this.hltf.createRecoverSliceTask(slice, (RecoverSliceTaskInteraction)guiInteraction);
    }

    @Override
    @Nonnull
    public DeleteDiskImageTask createDeleteDiskImageTask(@Nonnull Server auth, @Nonnull AggregateManagerWrapper.ImageInfo imageInfo) {
        return new DeleteDiskImageTask(auth, imageInfo, this.hltf);
    }

    @Override
    @Nonnull
    public OpenRequestRspecTask createOpenRequestRspecTask(@Nullable Window parentWindow, @Nonnull File file) throws FileNotFoundException {
        return new OpenRequestRspecTask(parentWindow, file, this.experimentEditorTabFactory, this.experimentEditorTabHost);
    }

    @Override
    @Nonnull
    public OpenRequestRspecTask createOpenRequestRspecTask(@Nullable Window parentWindow, @Nonnull InputStream inputStream, long fileLength, @Nonnull String name, @Nullable File defaultSaveFile) {
        return new OpenRequestRspecTask(parentWindow, inputStream, fileLength, name, defaultSaveFile, this.experimentEditorTabFactory, this.experimentEditorTabHost);
    }

    @Override
    @Nonnull
    public Task<EditableRspec> createOpenRequestRspecTaskFromString(@Nullable Window parentWindow, @Nonnull String requestRspecString) {
        return new OpenRequestRspecFromStringTask(parentWindow, requestRspecString, this.experimentEditorTabFactory, this.experimentEditorTabHost);
    }

    @Override
    @Nonnull
    public OpenRequestRspecTask createOpenRequestRspecTaskFromUrl(@Nullable Window parentWindow, @Nonnull String urlString) throws IOException {
        return new OpenRequestRspecTask(parentWindow, urlString, this.experimentEditorTabFactory, this.experimentEditorTabHost);
    }

    @Override
    @Nonnull
    public FetchAllSlicesInfoTask createFetchAllSlicesInfoTask() {
        return new FetchAllSlicesInfoTask(this.sfaModel, this.hltf, this.tt);
    }

    @Override
    @Nonnull
    public OpenTutorialTask createOpenTutorialTask(@Nullable Window dialogOwnerWindow, @Nonnull String urlString) throws IOException {
        return new OpenTutorialTask(dialogOwnerWindow, urlString, (TutorialViewsFactory)this.tutorialViewsFactoryProvider.get());
    }

    @Override
    @Nonnull
    public OpenESpecTask createOpenESpecTask(@Nullable Window dialogOwnerWindow, @Nonnull OpenESpecEvent event) throws IOException {
        return new OpenESpecTask(event, this.jFedPreferences, this.geniUserProvider, this.dialogsFactory, this.rSpecGeneratorFactory);
    }
}

