/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tutorials;

import be.iminds.ilabt.jfed.experimenter_gui.tutorials.DialogActionsProvider;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.Tutorial;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.TutorialDetailView;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.TutorialViewsFactory;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public class TutorialDescriptionView
extends HBox {
    private final Tutorial tutorial;
    private final TutorialViewsFactory viewsFactory;
    private final DialogActionsProvider dialogActionsProvider;
    @FXML
    private ImageView imageView;
    @FXML
    private Label titleLabel;
    @FXML
    Label descriptionLabel;
    @FXML
    Button startButton;

    public TutorialDescriptionView(Tutorial tutorial, TutorialViewsFactory viewsFactory, DialogActionsProvider dialogActionsProvider) {
        this.tutorial = tutorial;
        this.viewsFactory = viewsFactory;
        this.dialogActionsProvider = dialogActionsProvider;
        FXMLUtil.injectFXML((Object)((Object)this));
        this.titleLabel.setText(tutorial.getTitle());
        this.descriptionLabel.setText(tutorial.getDescription());
        if (tutorial.getImage() != null) {
            this.imageView.setImage(new Image(tutorial.getImage().toExternalForm(), true));
        }
        this.startButton.setOnAction(this::startTutorial);
    }

    private void startTutorial(ActionEvent actionEvent) {
        TutorialDetailView detailView = this.viewsFactory.createTutorialDetailView(this.tutorial);
        detailView.showDialog(this.dialogActionsProvider);
    }
}

