/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tutorials;

import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecFromInputStreamEvent;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.DialogActionsProvider;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.Tutorial;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import com.google.common.eventbus.EventBus;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class TutorialDetailView
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(TutorialDetailView.class);
    private static final String CLICK_EVENT = "click";
    private static final String ANCHOR_TAG = "a";
    private final EventBus eventBus;
    private final Tutorial tutorial;
    private final VBox headerTextPanel;
    private final Label titleLabel;
    private final Button homeButton;
    private final Button backButton;
    private final Button nextButton;
    private final WebView webView;
    private final WebEngine webEngine;
    private final StackPane contentPane;
    private final HBox loadingHBox;
    private final ProgressBar loadingProgressBar;
    private final Label loadingLabel;
    private final HBox filesHBox;
    private final String content;
    private final BooleanProperty tutorialIsShowing = new SimpleBooleanProperty(false);
    private final WebHistory history;

    public TutorialDetailView(Tutorial tutorial, EventBus eventBus) {
        this.eventBus = eventBus;
        this.tutorial = tutorial;
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("tutorial.css").toExternalForm());
        this.headerTextPanel = new VBox(5.0);
        this.headerTextPanel.getStyleClass().add((Object)"header-panel");
        this.setTop((Node)this.headerTextPanel);
        this.titleLabel = new Label();
        this.titleLabel.getStyleClass().add((Object)"title-label");
        this.headerTextPanel.getChildren().add((Object)this.titleLabel);
        this.titleLabel.setText(tutorial.getTitle());
        this.filesHBox = new HBox(15.0);
        this.filesHBox.getStyleClass().add((Object)"footer-panel");
        Label filesAvailableLabel = new Label("Available files:");
        this.filesHBox.getChildren().add((Object)filesAvailableLabel);
        this.setBottom((Node)this.filesHBox);
        if (tutorial.getFiles() != null && !tutorial.getFiles().isEmpty()) {
            for (Tutorial.TutFileWithContents tutFileWithContents : tutorial.getFiles()) {
                Button fileButton = new Button(tutFileWithContents.getName());
                fileButton.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.FOLDER_OPEN));
                fileButton.setOnAction(event -> this.openTutFile(tutFileWithContents));
                fileButton.setDisable(!Objects.equals(tutFileWithContents.getType(), "rspec"));
                this.filesHBox.getChildren().add((Object)fileButton);
            }
        } else {
            filesAvailableLabel.setText("No files available");
        }
        this.contentPane = new StackPane();
        this.contentPane.setAlignment(Pos.BOTTOM_CENTER);
        this.setCenter((Node)this.contentPane);
        this.webView = new WebView();
        this.webEngine = this.webView.getEngine();
        this.history = this.webEngine.getHistory();
        this.loadingHBox = new HBox(10.0);
        this.loadingHBox.setMaxHeight(20.0);
        this.loadingHBox.setAlignment(Pos.BOTTOM_LEFT);
        this.loadingHBox.setStyle("-fx-background-color: gray; -fx-opacity: 0.9;");
        this.loadingProgressBar = new ProgressBar();
        this.loadingProgressBar.setPrefWidth(150.0);
        this.loadingLabel = new Label("Loading ...");
        this.loadingHBox.getChildren().addAll((Object[])new Node[]{this.loadingProgressBar, this.loadingLabel});
        this.contentPane.getChildren().addAll((Object[])new Node[]{this.webView, this.loadingHBox});
        this.loadingProgressBar.progressProperty().bind((ObservableValue)this.webEngine.getLoadWorker().progressProperty());
        this.loadingHBox.visibleProperty().bind((ObservableValue)this.webEngine.getLoadWorker().runningProperty());
        this.webEngine.setConfirmHandler(param -> new Alert(Alert.AlertType.CONFIRMATION, param, new ButtonType[0]).showAndWait().filter(buttonType -> buttonType == ButtonType.YES).isPresent());
        this.webEngine.setOnAlert(text -> new Alert(Alert.AlertType.WARNING, text.toString(), new ButtonType[0]).show());
        this.webEngine.setOnError(error -> {
            LOG.info("Received ERROR from webview: {}", (Object)error.getMessage(), (Object)error.getException());
            JFDialogs.create().title("Error during tutorial").showException(error.getException());
        });
        this.webEngine.getLoadWorker().exceptionProperty().addListener(observable1 -> {
            Throwable exception = this.webEngine.getLoadWorker().getException();
            LOG.warn("Tutorial webview has error: {}", (Object)(exception != null ? exception.getMessage() : null), (Object)exception);
            JFDialogs.create().title("Error in webpage").message("jFed encountered an error while loading the login-webpage: " + exception.getMessage()).showException(exception);
        });
        this.loadingLabel.textProperty().bind((ObservableValue)this.webEngine.getLoadWorker().messageProperty());
        this.webEngine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                EventListener listener = ev -> System.out.println(ev.getType());
                Document doc = this.webEngine.getDocument();
                NodeList nl = doc.getElementsByTagName(ANCHOR_TAG);
                for (int i = 0; i < nl.getLength(); ++i) {
                    org.w3c.dom.Node node = nl.item(i);
                    EventTarget eventTarget = (EventTarget)((Object)node);
                    eventTarget.addEventListener(CLICK_EVENT, this::handleClick, false);
                }
            }
        });
        String tutorialText = Processor.process((String)tutorial.getText(), (Configuration)Configuration.builder().forceExtentedProfile().build());
        this.content = "<html><head><link rel='stylesheet' href='" + ((Object)((Object)this)).getClass().getResource("markdown.css").toExternalForm() + "'/></head><body class='markdown-body'>" + tutorialText + "</body></html>";
        this.webEngine.locationProperty().addListener(obs -> {
            if (this.webEngine.getLocation() != null) {
                this.tutorialIsShowing.set(false);
            }
        });
        this.showTutorialText();
        HBox buttonsBox = new HBox(5.0);
        this.homeButton = new Button();
        this.homeButton.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.HOME).size(18.0));
        this.homeButton.setOnAction(event -> this.showTutorialText());
        this.homeButton.setPrefWidth(35.0);
        this.homeButton.setPrefHeight(35.0);
        this.backButton = new Button();
        this.backButton.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.ARROW_LEFT).size(18.0));
        this.backButton.disableProperty().bind((ObservableValue)this.tutorialIsShowing);
        this.backButton.setOnAction(event -> {
            if (this.history.getCurrentIndex() > 0) {
                this.history.go(-1);
            } else {
                this.showTutorialText();
            }
        });
        this.backButton.setPrefWidth(35.0);
        this.backButton.setPrefHeight(35.0);
        this.nextButton = new Button();
        this.nextButton.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.ARROW_RIGHT).size(18.0));
        IntegerBinding historySize = Bindings.size((ObservableList)this.history.getEntries());
        this.nextButton.disableProperty().bind((ObservableValue)this.tutorialIsShowing.or((ObservableBooleanValue)historySize.isEqualTo(0).or((ObservableBooleanValue)this.history.currentIndexProperty().isEqualTo((ObservableNumberValue)historySize.subtract(1)))));
        this.nextButton.setOnAction(event -> this.history.go(1));
        this.nextButton.setPrefWidth(35.0);
        this.nextButton.setPrefHeight(35.0);
        buttonsBox.getChildren().addAll((Object[])new Node[]{this.homeButton, this.backButton, this.nextButton});
        this.headerTextPanel.getChildren().add((Object)buttonsBox);
        this.history.currentIndexProperty().addListener(obs -> LOG.info("New index: {}", (Object)this.history.getCurrentIndex()));
        this.history.getEntries().addListener(obs -> LOG.info("New number of entries: {}, index: {}", (Object)this.history.getEntries().size(), (Object)this.history.getCurrentIndex()));
    }

    private void showTutorialText() {
        this.webEngine.loadContent(this.content);
        this.tutorialIsShowing.set(true);
    }

    private void openTutFile(Tutorial.TutFileWithContents tutFile) {
        byte[] contentBytes = tutFile.getContent().trim().getBytes();
        this.eventBus.post((Object)new OpenRequestRspecFromInputStreamEvent(new ByteArrayInputStream(contentBytes), contentBytes.length, tutFile.getName()));
    }

    private void handleClick(Event event) {
        Element anchorElement = (Element)((Object)event.getCurrentTarget());
        String href = anchorElement.getAttribute("href");
        if (this.tutorial.getFiles() == null) {
            return;
        }
        try {
            URI uri = new URI(href);
            if (Objects.equals("tutfile", uri.getScheme())) {
                String schemeSpecificPart = uri.getSchemeSpecificPart();
                if (schemeSpecificPart.startsWith("//")) {
                    schemeSpecificPart = schemeSpecificPart.substring(2);
                }
                for (Tutorial.TutFileWithContents tutfile : this.tutorial.getFiles()) {
                    if (!Objects.equals(schemeSpecificPart, tutfile.getName())) continue;
                    this.openTutFile(tutfile);
                    event.preventDefault();
                    return;
                }
            }
        }
        catch (URISyntaxException e) {
            LOG.error("Could not parse given URI in tutorial: {}", (Object)href, (Object)e);
        }
    }

    public void showDialog(@Nullable DialogActionsProvider dialogActionsProvider) {
        Scene scene = new Scene((Parent)this, 800.0, 600.0);
        Stage tutorialStage = new Stage();
        StageUtils.setJFedStageIcons((Stage)tutorialStage);
        tutorialStage.setTitle(this.tutorial.getTitle());
        tutorialStage.setScene(scene);
        if (dialogActionsProvider != null) {
            tutorialStage.setOnShowing(event -> dialogActionsProvider.hideDialog());
            tutorialStage.setOnHidden(event -> dialogActionsProvider.showDialog());
        }
        tutorialStage.show();
    }
}

