/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.tutorials;

import be.iminds.ilabt.jfed.experimenter_gui.tutorials.DialogActionsProvider;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.Tutorial;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.TutorialDescriptionView;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.TutorialViewsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.tutorials.Tutorials;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class TutorialsView
extends ScrollPane
implements DialogActionsProvider {
    private final VBox container;
    private final Tutorials tutorials;
    private final TutorialViewsFactory tutorialViewsFactory;
    private final Scene scene = new Scene((Parent)this, 700.0, 600.0);
    private final Stage stage;

    public TutorialsView(Tutorials tutorials, TutorialViewsFactory tutorialViewsFactory) {
        this.tutorials = tutorials;
        this.tutorialViewsFactory = tutorialViewsFactory;
        this.container = new VBox(5.0);
        this.setContent((Node)this.container);
        this.container.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(4));
        for (Tutorial tutorial : tutorials.getTutorials()) {
            TutorialDescriptionView tutorialDescriptionView = tutorialViewsFactory.createTutorialDescriptionView(tutorial, this);
            this.container.getChildren().add((Object)tutorialDescriptionView);
            tutorialDescriptionView.prefWidthProperty().bind((ObservableValue)this.container.widthProperty());
        }
        this.stage = new Stage();
        this.stage.setMinWidth(405.0);
        this.stage.setMinHeight(635.0);
        this.stage.setScene(this.scene);
        StageUtils.setJFedStageIcons((Stage)this.stage);
        this.stage.setTitle("Tutorials");
    }

    @Override
    public void showDialog() {
        if (this.tutorials.getTutorials().size() > 1) {
            this.stage.show();
        } else if (this.tutorials.getTutorials().size() == 1) {
            this.tutorialViewsFactory.createTutorialDetailView(this.tutorials.getTutorials().get(0)).showDialog(null);
        } else {
            new Alert(Alert.AlertType.WARNING, "The tutorials file has no entries.", new ButtonType[0]).show();
        }
    }

    @Override
    public void hideDialog() {
        this.stage.hide();
    }
}

