/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import be.iminds.ilabt.jfed.experimenter_gui.ui.SceneAwareController;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDialogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDialogFactory.class);
    private static final String FACTORY_SUFFIX = "Factory";
    private final Provider<FXMLLoader> loaderProvider;
    private final Provider<? extends Window> ownerWindowProvider;

    public AbstractDialogFactory(Provider<FXMLLoader> loaderProvider, Provider<? extends Window> ownerWindowProvider) {
        this.loaderProvider = loaderProvider;
        this.ownerWindowProvider = ownerWindowProvider;
    }

    protected URL getFxmlLocation() {
        if (!this.getClass().getSimpleName().endsWith(FACTORY_SUFFIX)) {
            throw new RuntimeException("Automatic detection of FXML location can only happen when class ends on 'Factory'");
        }
        Object locationString = this.getClass().getSimpleName();
        locationString = ((String)locationString).substring(0, ((String)locationString).length() - FACTORY_SUFFIX.length());
        locationString = (String)locationString + ".fxml";
        return this.getClass().getResource((String)locationString);
    }

    protected abstract String getTitle();

    protected Image[] getIcons() {
        return new Image[]{new Image(AbstractDialogFactory.class.getResource("/images/jfed-logo_16.png").toExternalForm()), new Image(AbstractDialogFactory.class.getResource("/images/jfed-logo_32.png").toExternalForm()), new Image(AbstractDialogFactory.class.getResource("/images/jfed-logo_64.png").toExternalForm())};
    }

    public StageAndController createStage() {
        FXMLLoader loader = (FXMLLoader)this.loaderProvider.get();
        try {
            loader.setLocation(this.getFxmlLocation());
            Stage stage = new Stage();
            StageUtils.setJFedStageIcons((Stage)stage);
            stage.initOwner((Window)this.ownerWindowProvider.get());
            stage.setTitle(this.getTitle());
            stage.getIcons().addAll((Object[])this.getIcons());
            Scene scene = new Scene((Parent)loader.load());
            stage.setScene(scene);
            Object controller = loader.getController();
            if (controller instanceof SceneAwareController) {
                ((SceneAwareController)controller).registerScene(scene);
            }
            return new StageAndController(stage, controller);
        }
        catch (IOException e) {
            LOG.error("Could not show '" + this.getTitle() + "' dialog", (Throwable)e);
            throw new RuntimeException("Something went wrong showing the " + this.getTitle() + " dialog: " + e.getMessage(), e);
        }
    }

    public void showDialog() {
        StageAndController stageAndController = this.createStage();
        stageAndController.getStage().showAndWait();
    }

    public static class StageAndController {
        private final Stage stage;
        private final Object controller;

        StageAndController(Stage stage, Object controller) {
            this.stage = stage;
            this.controller = controller;
        }

        public Stage getStage() {
            return this.stage;
        }

        public Object getController() {
            return this.controller;
        }
    }
}

