/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import be.iminds.ilabt.jfed.experimenter_gui.debug.DebugGUIController;
import be.iminds.ilabt.jfed.experimenter_gui.debug.LogViewer;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.JFedBrowserFactory;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import com.google.inject.Injector;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceleratorService {
    private final Logger LOG = LoggerFactory.getLogger(AcceleratorService.class);
    private final GuiceFXMLUtil guiceFXMLUtil;
    private final Provider<LogViewer> logviewerProvider;
    private final JFedBrowserFactory jFedBrowserFactory;
    private final TestbedInfoSource testbedInfoSource;
    private final Injector injector;
    private Stage debugStage;

    @Inject
    public AcceleratorService(GuiceFXMLUtil guiceFXMLUtil, Provider<LogViewer> logviewerProvider, JFedBrowserFactory jFedBrowserFactory, Injector injector, TestbedInfoSource testbedInfoSource) {
        this.guiceFXMLUtil = guiceFXMLUtil;
        this.logviewerProvider = logviewerProvider;
        this.jFedBrowserFactory = jFedBrowserFactory;
        this.testbedInfoSource = testbedInfoSource;
        this.injector = injector;
    }

    public void registerOnScene(Scene scene) {
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F12, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), this::showDebugGui);
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F10, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> ((LogViewer)this.logviewerProvider.get()).show());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F4, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> {
            throw new DummyExceptionForTesting("Just a test exception");
        });
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> this.jFedBrowserFactory.showDialog());
    }

    public void showDebugGui() {
        if (this.debugStage == null) {
            GuiceFXMLUtil.Result fxmlResult = this.guiceFXMLUtil.createFromFXML(DebugGUIController.class);
            this.debugStage = new Stage();
            this.debugStage.setTitle("jFed DEBUGGING");
            this.debugStage.setResizable(false);
            this.debugStage.setScene(new Scene(fxmlResult.getRoot()));
            StageUtils.setJFedStageIcons((Stage)this.debugStage);
        }
        this.debugStage.show();
    }

    public static class DummyExceptionForTesting
    extends RuntimeException {
        public DummyExceptionForTesting() {
        }

        public DummyExceptionForTesting(String message) {
            super(message);
        }

        public DummyExceptionForTesting(String message, Throwable cause) {
            super(message, cause);
        }

        public DummyExceptionForTesting(Throwable cause) {
            super(cause);
        }

        public DummyExceptionForTesting(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

