/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javax.annotation.Nullable;

public class AvailabilityMeter
extends Group {
    private static final int HEIGHT = 20;
    protected final Rectangle outerAvailablityRect = new Rectangle(10.0, 20.0, (Paint)Color.LIGHTGRAY);
    protected final Rectangle innerAvailablityRect = new Rectangle(10.0, 20.0, (Paint)Color.LIGHTGRAY);
    protected final Text undeterminedText = new Text("?");
    private final IntegerProperty available = new SimpleIntegerProperty();
    private final IntegerProperty total = new SimpleIntegerProperty();
    private final BooleanProperty useVmCalculationMethod = new SimpleBooleanProperty(false);
    private final BooleanProperty undetermined = new SimpleBooleanProperty(false);

    public AvailabilityMeter() {
        this.undeterminedText.setX(2.0);
        this.undeterminedText.setY(15.0);
        this.undeterminedText.visibleProperty().bind((ObservableValue)this.undetermined);
        this.getChildren().addAll((Object[])new Node[]{this.outerAvailablityRect, this.innerAvailablityRect, this.undeterminedText});
        this.available.addListener(observable -> this.update());
        this.total.addListener(observable -> this.update());
        this.useVmCalculationMethod.addListener(observable -> this.update());
    }

    private double calculateHeight() {
        if (this.available.get() == 0) {
            return 0.0;
        }
        if (this.useVmCalculationMethod.get()) {
            double value = 10.0 - -120.0 * (1.0 - Math.exp(-0.005 * (double)this.available.get()));
            return value /= 130.0;
        }
        return (double)Math.min(this.available.get(), 100) / 100.0;
    }

    private void update() {
        double newHeight = this.calculateHeight();
        this.innerAvailablityRect.setY(20.0 * (1.0 - newHeight));
        this.innerAvailablityRect.setHeight(20.0 * newHeight);
        if (newHeight > 0.75) {
            this.innerAvailablityRect.setFill((Paint)Color.GREEN);
        } else if (newHeight > 0.5) {
            this.innerAvailablityRect.setFill((Paint)Color.YELLOWGREEN);
        } else if (newHeight > 0.25) {
            this.innerAvailablityRect.setFill((Paint)Color.ORANGE);
        } else {
            this.innerAvailablityRect.setFill((Paint)Color.RED);
        }
    }

    public int getAvailable() {
        return this.available.get();
    }

    public IntegerProperty availableProperty() {
        return this.available;
    }

    public void setAvailable(@Nullable Integer available) {
        this.available.set(available == null ? -1 : available);
    }

    public int getTotal() {
        return this.total.get();
    }

    public IntegerProperty totalProperty() {
        return this.total;
    }

    public void setTotal(@Nullable Integer total) {
        this.total.set(total == null ? -1 : total);
    }

    public boolean getUseVmCalculationMethod() {
        return this.useVmCalculationMethod.get();
    }

    public BooleanProperty useVmCalculationMethodProperty() {
        return this.useVmCalculationMethod;
    }

    public void setUseVmCalculationMethod(boolean useVmCalculationMethod) {
        this.useVmCalculationMethod.set(useVmCalculationMethod);
    }

    public boolean getUndetermined() {
        return this.undetermined.get();
    }

    public BooleanProperty undeterminedProperty() {
        return this.undetermined;
    }

    public void setUndetermined(boolean undetermined) {
        this.undetermined.set(undetermined);
    }
}

