/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.util.Objects;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.annotation.Nonnull;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInfoCell
extends ListCell<JFedGuiConfig.ComponentInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentInfoCell.class);
    @Nonnull
    private final Resource resource;
    @Nonnull
    private final JFedGuiConfig config;
    protected final HBox container = new HBox(2.0);
    protected final Pane fillerPane;
    protected final Label nameLabel = new Label("--init--");
    protected final Glyph availableIcon = GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CALENDAR, (Color)Color.GREEN);
    protected final Glyph loginIcon = GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TERMINAL, (Color)Color.GREEN);
    protected final Glyph sensorGlyph = GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TACHOMETER, (Color)Color.GREEN);

    public ComponentInfoCell(@Nonnull Resource resource, @Nonnull JFedGuiConfig config) {
        this.config = config;
        this.resource = resource;
        this.fillerPane = new Pane();
        HBox.setHgrow((Node)this.fillerPane, (Priority)Priority.ALWAYS);
        this.container.setPadding(new Insets(0.0, 5.0, 2.0, 0.0));
        this.container.getChildren().addAll((Object[])new Node[]{this.nameLabel, this.fillerPane, this.availableIcon, this.loginIcon, this.sensorGlyph});
        this.container.setMinWidth(Double.NEGATIVE_INFINITY);
        this.nameLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.setGraphic((Node)this.container);
    }

    protected void updateItem(JFedGuiConfig.ComponentInfo item, boolean empty) {
        assert (Platform.isFxApplicationThread());
        super.updateItem((Object)item, empty);
        this.setText(null);
        this.setGraphic((Node)this.container);
        this.container.setMinWidth(Double.NEGATIVE_INFINITY);
        this.nameLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        if (!empty && item != null) {
            if (item.getName().trim().isEmpty()) {
                this.nameLabel.setText("-- no name --");
            } else {
                this.nameLabel.setText(item.getName());
            }
            if (item.hasExtraStatus(JFedGuiConfig.ComponentInfo.ExtraStatusInfoType.NODE_LOGIN)) {
                this.loginIcon.setVisible(true);
                this.loginIcon.setManaged(true);
                if (Objects.equals(item.isSuccess(JFedGuiConfig.ComponentInfo.ExtraStatusInfoType.NODE_LOGIN), Boolean.TRUE)) {
                    this.loginIcon.setTextFill((Paint)Color.GREEN);
                } else {
                    this.loginIcon.setTextFill((Paint)Color.RED);
                }
            } else {
                this.loginIcon.setVisible(false);
                this.loginIcon.setManaged(false);
            }
            if (item.hasExtraStatus(JFedGuiConfig.ComponentInfo.ExtraStatusInfoType.SENSOR)) {
                this.sensorGlyph.setVisible(true);
                this.sensorGlyph.setManaged(true);
                if (Objects.equals(item.isSuccess(JFedGuiConfig.ComponentInfo.ExtraStatusInfoType.SENSOR), Boolean.TRUE)) {
                    this.sensorGlyph.setTextFill((Paint)Color.GREEN);
                } else {
                    this.sensorGlyph.setTextFill((Paint)Color.RED);
                }
            } else {
                this.sensorGlyph.setVisible(false);
                this.sensorGlyph.setManaged(false);
            }
            if (item.isAvailable()) {
                this.nameLabel.setTextFill((Paint)Color.BLACK);
            } else {
                this.nameLabel.setTextFill((Paint)Color.GRAY);
            }
            this.availableIcon.setVisible(false);
            this.availableIcon.setManaged(false);
        } else {
            this.nameLabel.setText("");
            this.loginIcon.setVisible(false);
            this.loginIcon.setManaged(false);
            this.sensorGlyph.setVisible(false);
            this.sensorGlyph.setManaged(false);
            this.availableIcon.setVisible(false);
            this.availableIcon.setManaged(false);
        }
        this.nameLabel.setVisible(true);
        this.nameLabel.setManaged(true);
    }
}

