/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class ConfirmingPasswordInputDialog
extends Dialog<String> {
    private static final PseudoClass ERROR_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"error");
    private final GridPane grid;
    private final Label label;
    private final Label label1;
    private final Label label2;
    private final PasswordField passwordField1;
    private final PasswordField passwordField2;
    private final IntegerProperty minimumPasswordSize = new SimpleIntegerProperty(4);
    private final BooleanBinding invalidPassword1Length;
    private final BooleanBinding validLengthPasswordBinding;
    private final BooleanBinding matchingPasswordBinding;

    public ConfirmingPasswordInputDialog() {
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("confirming-password.css").toExternalForm());
        this.passwordField1 = new PasswordField();
        this.passwordField1.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.passwordField1, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.passwordField1, (Boolean)true);
        this.passwordField2 = new PasswordField();
        this.passwordField2.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.passwordField2, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.passwordField2, (Boolean)true);
        this.label = ConfirmingPasswordInputDialog.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        this.label1 = ConfirmingPasswordInputDialog.createContentLabel("Password:");
        this.label1.setPrefWidth(-1.0);
        this.label1.setAlignment(Pos.BASELINE_RIGHT);
        this.label2 = ConfirmingPasswordInputDialog.createContentLabel("Confirm:");
        this.label2.setPrefWidth(-1.0);
        this.label2.setAlignment(Pos.BASELINE_RIGHT);
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setVgap(5.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.setTitle("Please confirm your password");
        dialogPane.setHeaderText("Please confirm your password");
        dialogPane.getStyleClass().add((Object)"text-input-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? this.passwordField1.getText() : null;
        });
        Node okButton = this.getDialogPane().lookupButton(ButtonType.OK);
        this.invalidPassword1Length = Bindings.length((ObservableStringValue)this.passwordField1.textProperty()).lessThan((ObservableNumberValue)this.minimumPasswordSize);
        this.invalidPassword1Length.addListener(observable -> this.passwordField1.pseudoClassStateChanged(ERROR_PSEUDO_CLASS, this.invalidPassword1Length.get()));
        this.validLengthPasswordBinding = Bindings.length((ObservableStringValue)this.passwordField1.textProperty()).greaterThanOrEqualTo((ObservableNumberValue)this.minimumPasswordSize);
        this.matchingPasswordBinding = Bindings.equal((ObservableStringValue)this.passwordField1.textProperty(), (ObservableStringValue)this.passwordField2.textProperty());
        okButton.disableProperty().bind((ObservableValue)this.validLengthPasswordBinding.not().or((ObservableBooleanValue)this.matchingPasswordBinding.not()));
        this.matchingPasswordBinding.addListener(observable -> this.passwordField2.pseudoClassStateChanged(ERROR_PSEUDO_CLASS, !this.matchingPasswordBinding.get()));
    }

    static Label createContentLabel(String text) {
        Label label = new Label(text);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.getStyleClass().add((Object)"content");
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public final PasswordField getEditor() {
        return this.passwordField1;
    }

    public void setConfirmText(String text) {
        this.label2.setText(text);
    }

    public String getConfirmText() {
        return this.label2.getText();
    }

    public StringProperty confirmTextProperty() {
        return this.label2.textProperty();
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add((Node)this.label, 0, 0, 2, 1);
        this.grid.add((Node)this.label1, 0, 1);
        this.grid.add((Node)this.passwordField1, 1, 1);
        this.grid.add((Node)this.label2, 0, 2);
        this.grid.add((Node)this.passwordField2, 1, 2);
        this.getDialogPane().setContent((Node)this.grid);
        Platform.runLater(() -> ((PasswordField)this.passwordField1).requestFocus());
    }
}

