/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.ui.AvailabilityMeter;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.DateTimeUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.util.common.TimeUtil;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.controlsfx.control.PopOver;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthStatusPane
extends StackPane {
    private static final Logger LOG = LoggerFactory.getLogger(HealthStatusPane.class);
    private static final Comparator<? super MaintenanceInfo> MAINTENANCE_MESSAGE_COMPARATOR = Comparator.nullsLast(Comparator.comparing(MaintenanceInfo::getStart)).thenComparing(Comparator.nullsLast(Comparator.comparing(MaintenanceInfo::getEnd))).thenComparing(Comparator.nullsLast(Comparator.comparing(MaintenanceInfo::getPlanned))).thenComparing(MaintenanceInfo::getMessage).thenComparing(Comparator.nullsLast(Comparator.comparing(MaintenanceInfo::getReported)));
    @FXML
    private Label noInfoLabel;
    @FXML
    private GridPane infoGridPane;
    @FXML
    private Label healthKeyLabel;
    @FXML
    private Label healthLabel;
    @FXML
    private Label reputationLabel;
    @FXML
    private Label freeLabel;
    @FXML
    private Label freeInfoLabel;
    @FXML
    private Label freeHwInfoLabel;
    @FXML
    private Label ipFreeLabel;
    @FXML
    private Label ipFreeInfoLabel;
    @FXML
    private Label maintenanceLabel;
    @FXML
    private Glyph healthGlyph;
    @FXML
    private Glyph reputationGlyph;
    @FXML
    private AvailabilityMeter availabiltyMeter;
    @FXML
    private AvailabilityMeter ipAvailabiltyMeter;
    @FXML
    private Glyph maintenanceGlyph;
    @FXML
    private Button hwFreeInfoButton;
    @FXML
    private Button maintenanceInfoButton;
    @FXML
    private Label updateHealthDateLabel;
    @FXML
    private Label updateCountsDateLabel;
    @FXML
    private Button refreshButton;
    @FXML
    private Glyph refreshGlyph;
    @FXML
    private Hyperlink testbedInfoButton;
    @FXML
    private Hyperlink testbedDocumentationButton;
    @FXML
    private Hyperlink testbedHardwareTypeInfoButton;
    private JFedGuiConfig config;
    private Server server;
    private final ObjectProperty<JFedGuiConfig.ResourceType> type = new SimpleObjectProperty(null);
    private final StringProperty documentationLink = new SimpleStringProperty();
    private final StringProperty infoLink = new SimpleStringProperty();
    private final StringProperty hardwareTypeInfoLink = new SimpleStringProperty();
    private BrowserUtil browserUtil;
    private Runnable unregisterServer;

    @Inject
    public HealthStatusPane() {
        FXMLUtil.injectFXML((Object)((Object)this));
        this.availabiltyMeter.useVmCalculationMethodProperty().bind((ObservableValue)this.type.isEqualTo((Object)JFedGuiConfig.ResourceType.VM));
        this.testbedInfoButton.disableProperty().bind((ObservableValue)this.infoLink.isEmpty());
        this.testbedInfoButton.setOnAction(event -> this.browserUtil.openUrlInBrowser(this.infoLink.getValue()));
        this.testbedDocumentationButton.disableProperty().bind((ObservableValue)this.documentationLink.isEmpty());
        this.testbedDocumentationButton.setOnAction(event -> this.browserUtil.openUrlInBrowser(this.documentationLink.getValue()));
        this.testbedHardwareTypeInfoButton.visibleProperty().bind((ObservableValue)this.hardwareTypeInfoLink.isEmpty().not());
        this.testbedHardwareTypeInfoButton.setOnAction(event -> this.browserUtil.openUrlInBrowser(this.hardwareTypeInfoLink.getValue()));
    }

    public void setBrowserUtil(BrowserUtil browserUtil) {
        this.browserUtil = browserUtil;
    }

    @FXML
    public void initialize() {
    }

    public void setConfig(@Nonnull JFedGuiConfig config) {
        this.reputationGlyph.setVisible(config.isShowReputationEnabled());
        this.config = config;
        if (this.server != null) {
            this.setServer(this.server);
        }
    }

    public void setServer(Server server) {
        this.server = server;
        if (this.unregisterServer != null) {
            this.unregisterServer.run();
        }
        if (this.config == null) {
            return;
        }
        boolean noInfo = true;
        if (this.config.getServerNodeCounts(server).getValue() != null && ((AdvertisementCounts)this.config.getServerNodeCounts(server).getValue()).getCountEntriesSize() > 0) {
            noInfo = false;
        }
        if (noInfo && !this.config.getServerHealthInfo(server).isBound()) {
            noInfo = false;
        }
        if (noInfo && !this.config.getHardwareTypeInfo(server).isBound()) {
            noInfo = false;
        }
        if (noInfo && !this.config.getServerMaintenance(server).isEmpty()) {
            noInfo = false;
        }
        if (noInfo && !this.config.getServerReputation(server).isBound()) {
            noInfo = false;
        }
        if (noInfo) {
            this.noInfoLabel.setVisible(true);
            this.infoGridPane.setVisible(false);
            return;
        }
        this.noInfoLabel.setVisible(false);
        this.infoGridPane.setVisible(true);
        ChangeListener healthListener = (observable, oldValue, newValue) -> this.showHealthInfo((ServerGlimpse.HealthInfo)newValue);
        this.config.getServerHealthInfo(server).addListener(healthListener);
        this.showHealthInfo((ServerGlimpse.HealthInfo)this.config.getServerHealthInfo(server).get());
        ChangeListener hardwareTypeInfoListener = (observable, oldValue, newValue) -> this.showHardwareTypeInfo((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo)newValue);
        this.config.getHardwareTypeInfo(server).addListener(hardwareTypeInfoListener);
        this.showHardwareTypeInfo((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo)this.config.getHardwareTypeInfo(server).get());
        ChangeListener reputationListener = (observable, oldValue, newValue) -> this.showReputation((Integer)newValue);
        this.config.getServerReputation(server).addListener(reputationListener);
        this.showReputation((Integer)this.config.getServerReputation(server).get());
        this.showLinks(server);
        ListChangeListener maintenanceChangeListener = change -> this.showMaintenance((Collection<? extends MaintenanceInfo>)change.getList());
        this.config.getServerMaintenance(server).addListener(maintenanceChangeListener);
        this.showMaintenance((Collection<? extends MaintenanceInfo>)this.config.getServerMaintenance(server));
        ChangeListener serverNodeCountChangeListener = (observable, oldValue, newValue) -> Platform.runLater(() -> this.showCounts((AdvertisementCounts)newValue));
        this.config.getServerNodeCounts(server).addListener(serverNodeCountChangeListener);
        Platform.runLater(() -> this.showCounts((AdvertisementCounts)this.config.getServerNodeCounts(server).get()));
        this.unregisterServer = () -> {
            this.config.getServerHealthInfo(server).removeListener(healthListener);
            this.config.getHardwareTypeInfo(server).removeListener(hardwareTypeInfoListener);
            this.config.getServerReputation(server).removeListener(reputationListener);
            this.config.getServerMaintenance(server).removeListener(maintenanceChangeListener);
            this.config.getServerNodeCounts(server).removeListener(serverNodeCountChangeListener);
            this.showLinks(null);
        };
    }

    public void showHardwareTypeInfo(@Nullable ServerGlimpse.AdvertisementInfo.HardwareTypeInfo hardwareTypeInfo) {
        this.hardwareTypeInfoLink.setValue(hardwareTypeInfo == null ? null : (hardwareTypeInfo.getHtmlOverview() == null ? null : hardwareTypeInfo.getHtmlOverview().toASCIIString()));
    }

    public void showHealthInfo(@Nullable ServerGlimpse.HealthInfo healthInfo) {
        if (healthInfo == null) {
            this.healthLabel.setText("No Health info");
            return;
        }
        Tooltip healthTooltip = healthInfo.getHealthExplanationFull() != null ? new Tooltip(healthInfo.getHealthExplanationFull()) : new Tooltip("Health explanation unknown");
        this.healthLabel.setText((String)(healthInfo.getHealth() != null ? healthInfo.getHealth() + "%" : "-"));
        HealthStatusPane.setGlyphColor(this.healthGlyph, healthInfo.getHealth());
        this.healthLabel.setTooltip(healthTooltip);
        this.healthKeyLabel.setTooltip(healthTooltip);
        this.healthGlyph.setTooltip(healthTooltip);
        String healthTime = healthInfo.getTimestamp() != null ? TimeUtil.calcAgo((Date)healthInfo.getTimestamp()) : "at unknown time";
        this.updateHealthDateLabel.setText("Health updated " + healthTime + ".");
    }

    public void showReputation(@Nullable Integer reputation) {
        this.reputationLabel.setText((String)(reputation != null ? reputation + "%" : "-"));
        HealthStatusPane.setGlyphColor(this.reputationGlyph, reputation);
    }

    public void showLinks(@Nullable Server server) {
        Testbed testbed = server == null ? null : server.getTestbed();
        this.infoLink.setValue(testbed == null ? null : testbed.getInfoUrl());
        this.documentationLink.setValue(testbed == null ? null : testbed.getHelpUrl());
    }

    public void showCounts(@Nullable AdvertisementCounts counts) {
        assert (Platform.isFxApplicationThread());
        LOG.debug("HealthStatusPane count update: counts==null -> {}  type.get()={}", (Object)(counts == null ? 1 : 0), this.type.get());
        if (counts != null) {
            if (this.type.get() != null) {
                Integer countAvail;
                Integer countTotal = switch ((JFedGuiConfig.ResourceType)this.type.get()) {
                    case JFedGuiConfig.ResourceType.RAW_PC -> {
                        countAvail = counts.getCount(AdvertisementCounts.CountedObject.RAW_PC, AdvertisementCounts.CountScope.AVAILABLE);
                        yield counts.getCount(AdvertisementCounts.CountedObject.RAW_PC, AdvertisementCounts.CountScope.ALL);
                    }
                    case JFedGuiConfig.ResourceType.VM -> {
                        countAvail = counts.getCount(AdvertisementCounts.CountedObject.VM, AdvertisementCounts.CountScope.AVAILABLE);
                        yield counts.getCount(AdvertisementCounts.CountedObject.VM, AdvertisementCounts.CountScope.ALL);
                    }
                    default -> {
                        countAvail = counts.getCount(AdvertisementCounts.CountedObject.ANY, AdvertisementCounts.CountScope.AVAILABLE);
                        yield counts.getCount(AdvertisementCounts.CountedObject.ANY, AdvertisementCounts.CountScope.ALL);
                    }
                };
                LOG.debug("HealthStatusPane count update: {}/{}", (Object)countAvail, (Object)countTotal);
                if (countAvail != null && countTotal != null && countTotal != 0) {
                    this.freeLabel.setText("Free " + ((JFedGuiConfig.ResourceType)this.type.get()).getFriendlyName() + ":");
                    this.availabiltyMeter.setAvailable(countAvail);
                    this.availabiltyMeter.setTotal(countTotal);
                    this.availabiltyMeter.setUndetermined(false);
                    this.freeInfoLabel.setText(countAvail + " of " + countTotal);
                    this.hwFreeInfoButton.setVisible(!counts.getHwCountKeys().isEmpty());
                    this.hwFreeInfoButton.setManaged(!counts.getHwCountKeys().isEmpty());
                } else {
                    this.freeLabel.setText("Free resources:");
                    this.availabiltyMeter.setAvailable(0);
                    this.availabiltyMeter.setTotal(0);
                    this.availabiltyMeter.setUndetermined(true);
                    this.freeInfoLabel.setText("-");
                    this.freeHwInfoLabel.setVisible(false);
                    this.hwFreeInfoButton.setVisible(false);
                    this.hwFreeInfoButton.setManaged(false);
                }
            }
            Integer countIpv4Avail = counts.getCount(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.AVAILABLE);
            Integer countIpv4Total = counts.getCount(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.ALL);
            if (countIpv4Total != null && countIpv4Total > 0) {
                this.ipAvailabiltyMeter.setAvailable(countIpv4Avail);
                this.ipAvailabiltyMeter.setTotal(countIpv4Total);
                this.ipAvailabiltyMeter.setUndetermined(false);
                this.ipFreeInfoLabel.setText(countIpv4Avail + " of " + countIpv4Total);
            } else {
                this.ipAvailabiltyMeter.setAvailable(0);
                this.ipAvailabiltyMeter.setTotal(0);
                this.ipAvailabiltyMeter.setUndetermined(true);
                this.ipFreeInfoLabel.setText("-");
            }
            String countsTime = counts.getCountDate() != null ? TimeUtil.calcAgo((Date)counts.getCountDate()) : "at unknown time";
            this.updateCountsDateLabel.setText("Counts updated " + countsTime + ".");
        } else {
            this.ipAvailabiltyMeter.setAvailable(0);
            this.ipAvailabiltyMeter.setTotal(0);
            this.ipAvailabiltyMeter.setUndetermined(true);
            this.ipFreeInfoLabel.setText("-");
            this.freeLabel.setText("Free resources:");
            this.availabiltyMeter.setAvailable(0);
            this.availabiltyMeter.setTotal(0);
            this.availabiltyMeter.setUndetermined(true);
            this.freeInfoLabel.setText("-");
            this.freeHwInfoLabel.setVisible(false);
            this.hwFreeInfoButton.setVisible(false);
            this.hwFreeInfoButton.setManaged(false);
            this.updateCountsDateLabel.setText("Count info not available.");
        }
    }

    public void showMaintenance(@Nullable Collection<? extends MaintenanceInfo> maintenance) {
        Optional<Object> upcomingMaintenance;
        Optional<Object> activeMaintenance;
        if (maintenance != null && !maintenance.isEmpty()) {
            activeMaintenance = maintenance.stream().filter(mm -> mm.getStartTime() == null || mm.getStartTime().isBefore(ZonedDateTime.now())).filter(mm -> mm.getEndTime() == null || mm.getEndTime().isAfter(ZonedDateTime.now())).sorted(MAINTENANCE_MESSAGE_COMPARATOR).findFirst();
            upcomingMaintenance = maintenance.stream().filter(mm -> mm.getStartTime() != null && mm.getStartTime().isAfter(ZonedDateTime.now())).sorted(MAINTENANCE_MESSAGE_COMPARATOR).findFirst();
        } else {
            activeMaintenance = Optional.empty();
            upcomingMaintenance = Optional.empty();
        }
        if (activeMaintenance.isPresent()) {
            ZonedDateTime endTime;
            StringBuilder maintenanceMsg = new StringBuilder("Currently in maintenance ");
            ZonedDateTime startTime = ((MaintenanceInfo)activeMaintenance.get()).getStartTime();
            if (startTime != null) {
                maintenanceMsg.append("from ").append(DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(startTime.withZoneSameInstant(ZoneId.systemDefault()))).append(" ");
            }
            if ((endTime = ((MaintenanceInfo)activeMaintenance.get()).getEndTime()) != null) {
                maintenanceMsg.append("until ").append(DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(endTime.withZoneSameInstant(ZoneId.systemDefault())));
            }
            this.maintenanceLabel.setText(maintenanceMsg.toString());
            this.maintenanceGlyph.setTextFill((Paint)Color.RED);
        } else if (upcomingMaintenance.isPresent()) {
            ZonedDateTime endTime;
            StringBuilder maintenanceMsg = new StringBuilder("Upcoming maintenance ");
            ZonedDateTime startTime = ((MaintenanceInfo)upcomingMaintenance.get()).getStartTime();
            if (startTime != null) {
                maintenanceMsg.append("from ").append(DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(startTime.withZoneSameInstant(ZoneId.systemDefault()))).append(" ");
            }
            if ((endTime = ((MaintenanceInfo)upcomingMaintenance.get()).getEndTime()) != null) {
                maintenanceMsg.append("until ").append(DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(endTime.withZoneSameInstant(ZoneId.systemDefault())));
            }
            this.maintenanceLabel.setText(maintenanceMsg.toString());
            this.maintenanceGlyph.setTextFill((Paint)Color.ORANGE);
        } else {
            this.maintenanceLabel.setText("None planned");
            this.maintenanceGlyph.setTextFill((Paint)Color.GRAY);
        }
        this.maintenanceInfoButton.setDisable(!activeMaintenance.isPresent() && !upcomingMaintenance.isPresent());
    }

    @FXML
    private void refresh() {
        if (this.config != null) {
            LOG.debug("Updating ServerGlimpses");
            this.config.forceRefreshServerGlimpses();
        } else {
            LOG.warn("Internal error: Cannot refresh");
        }
    }

    @FXML
    private void toggleHwFree() {
        AdvertisementCounts counts = (AdvertisementCounts)this.config.getServerNodeCounts(this.server).get();
        assert (counts != null);
        if (counts == null) {
            return;
        }
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"grid");
        int rowIndex = 0;
        gridPane.setHgap(10.0);
        gridPane.setVgap(2.0);
        ColumnConstraints colA = new ColumnConstraints();
        colA.setHgrow(Priority.ALWAYS);
        ColumnConstraints colB = new ColumnConstraints();
        colB.setHgrow(Priority.ALWAYS);
        ColumnConstraints colC = new ColumnConstraints();
        colC.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colA, colB, colC});
        Label headerA = new Label("Type");
        headerA.setStyle("-fx-font-weight: bold");
        Label headerB = new Label("Available");
        headerB.setStyle("-fx-font-weight: bold");
        Label headerC = new Label("Total");
        headerC.setStyle("-fx-font-weight: bold");
        gridPane.getChildren().addAll((Object[])new Node[]{headerA, headerB, headerC});
        GridPane.setRowIndex((Node)headerA, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)headerA, (Integer)0);
        GridPane.setRowIndex((Node)headerB, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)headerB, (Integer)1);
        GridPane.setRowIndex((Node)headerC, (Integer)rowIndex);
        GridPane.setColumnIndex((Node)headerC, (Integer)2);
        headerA.getStyleClass().add((Object)"cell");
        headerB.getStyleClass().add((Object)"cell");
        headerC.getStyleClass().add((Object)"cell");
        headerA.getStyleClass().add((Object)"header");
        headerB.getStyleClass().add((Object)"header");
        headerC.getStyleClass().add((Object)"header");
        headerA.setMaxWidth(10000.0);
        headerB.setMaxWidth(10000.0);
        headerC.setMaxWidth(10000.0);
        ++rowIndex;
        ++rowIndex;
        ArrayList hwCountKeys = new ArrayList(counts.getHwCountKeys());
        Collections.sort(hwCountKeys, Comparator.comparing(s -> s.toLowerCase().replaceAll("[^a-z0-9]*", "")));
        LOG.debug("Health is showing hw type counts: " + String.valueOf(hwCountKeys));
        for (String hwType : hwCountKeys) {
            Integer allCount = counts.getHwCount(hwType, AdvertisementCounts.CountScope.ALL);
            Integer availCount = counts.getHwCount(hwType, AdvertisementCounts.CountScope.AVAILABLE);
            ++rowIndex;
            Label countA = new Label(hwType);
            Label countB = new Label("" + availCount);
            Label countC = new Label("" + allCount);
            gridPane.getChildren().addAll((Object[])new Node[]{countA, countB, countC});
            GridPane.setRowIndex((Node)countA, (Integer)rowIndex);
            GridPane.setColumnIndex((Node)countA, (Integer)0);
            GridPane.setRowIndex((Node)countB, (Integer)rowIndex);
            GridPane.setColumnIndex((Node)countB, (Integer)1);
            GridPane.setRowIndex((Node)countC, (Integer)rowIndex);
            GridPane.setColumnIndex((Node)countC, (Integer)2);
            countA.getStyleClass().add((Object)"cell");
            countB.getStyleClass().add((Object)"cell");
            countC.getStyleClass().add((Object)"cell");
            countA.setMaxWidth(10000.0);
            countB.setMaxWidth(10000.0);
            countC.setMaxWidth(10000.0);
        }
        StackPane popOverRoot = new StackPane();
        popOverRoot.getChildren().add((Object)gridPane);
        popOverRoot.setPadding(new Insets(10.0));
        PopOver popOver = new PopOver((Node)popOverRoot);
        popOver.show((Node)this.hwFreeInfoButton);
    }

    @FXML
    private void showMaintenanceInfo() {
        ObservableList maintenances = this.config.getServerMaintenance(this.server);
        assert (maintenances != null);
        assert (!maintenances.isEmpty());
        ArrayList<MaintenanceInfo> sortedMaintenances = new ArrayList<MaintenanceInfo>((Collection<MaintenanceInfo>)maintenances);
        sortedMaintenances.sort(MAINTENANCE_MESSAGE_COMPARATOR);
        Alert infoAlert = new Alert(Alert.AlertType.INFORMATION);
        infoAlert.setHeaderText("Planned maintenance");
        infoAlert.setContentText(HealthStatusPane.formatMaintenanceInfos(sortedMaintenances));
        infoAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        infoAlert.setResizable(true);
        infoAlert.showAndWait();
    }

    private static void setGlyphColor(@Nonnull Glyph glyph, @Nullable Integer value) {
        if (value == null) {
            glyph.setTextFill((Paint)Color.GRAY);
        } else if (value > 95) {
            glyph.setTextFill((Paint)Color.GREEN);
        } else if (value > 66) {
            glyph.setTextFill((Paint)Color.YELLOWGREEN);
        } else if (value > 33) {
            glyph.setTextFill((Paint)Color.ORANGE);
        } else {
            glyph.setTextFill((Paint)Color.RED);
        }
    }

    public JFedGuiConfig.ResourceType getType() {
        return (JFedGuiConfig.ResourceType)this.type.get();
    }

    public ObjectProperty<JFedGuiConfig.ResourceType> typeProperty() {
        return this.type;
    }

    public void setType(JFedGuiConfig.ResourceType type) {
        this.type.set((Object)type);
    }

    @Nonnull
    public static String formatMaintenanceInfos(List<MaintenanceInfo> maintenanceInfos) {
        StringBuilder maintenanceMsg = new StringBuilder();
        for (MaintenanceInfo activeMaintenance : maintenanceInfos) {
            if (activeMaintenance.getStartTime() != null && activeMaintenance.getEndTime() != null) {
                maintenanceMsg.append("From ").append(DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(activeMaintenance.getStartTime().withZoneSameInstant(ZoneId.systemDefault()))).append(" until ").append(DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(activeMaintenance.getEndTime().withZoneSameInstant(ZoneId.systemDefault()))).append(": ");
            } else if (activeMaintenance.getStartTime() != null) {
                maintenanceMsg.append("From ").append(DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(activeMaintenance.getStartTime().withZoneSameInstant(ZoneId.systemDefault()))).append(": ");
            } else if (activeMaintenance.getEndTime() != null) {
                maintenanceMsg.append("Until ").append(DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(activeMaintenance.getEndTime().withZoneSameInstant(ZoneId.systemDefault()))).append(": ");
            }
            maintenanceMsg.append(activeMaintenance.getMessage()).append("\n\n");
        }
        return maintenanceMsg.toString().trim();
    }
}

