/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.regex.Pattern;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;

public class LocalTimeTextField
extends TextField {
    private static final String DEFAULT_WITH_SECONDS = "00:00:00";
    private static final String DEFAULT_WITHOUT_SECONDS = "00:00";
    private static final Pattern TIME_WITH_SECONDS_PATTERN = Pattern.compile("\\d\\d:\\d\\d:\\d\\d");
    private static final Pattern TIME_WITHOUT_SECONDS_PATTERN = Pattern.compile("\\d\\d:\\d\\d");
    private static final DateTimeFormatter FORMAT_WITH_SECONDS_PATTERN = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter FORMAT_WITHOUT_SECONDS_PATTERN = DateTimeFormatter.ofPattern("HH:mm");
    private final ObjectProperty<LocalTime> time = new SimpleObjectProperty((Object)LocalTime.of(0, 0, 0));
    private final BooleanProperty showSeconds = new SimpleBooleanProperty(true);
    private Pattern timePattern = TIME_WITH_SECONDS_PATTERN;

    public LocalTimeTextField() {
        this(true);
    }

    public LocalTimeTextField(boolean showSeconds) {
        super(showSeconds ? DEFAULT_WITH_SECONDS : DEFAULT_WITHOUT_SECONDS);
        this.showSeconds.addListener(observable -> {
            this.timePattern = this.showSeconds.get() ? TIME_WITH_SECONDS_PATTERN : TIME_WITHOUT_SECONDS_PATTERN;
            this.setText(this.getText());
        });
        this.textProperty().bindBidirectional(this.timeProperty(), (StringConverter)new StringConverter<LocalTime>(){

            public String toString(LocalTime object) {
                if (LocalTimeTextField.this.showSeconds.get()) {
                    return object.format(FORMAT_WITH_SECONDS_PATTERN);
                }
                return object.format(FORMAT_WITHOUT_SECONDS_PATTERN);
            }

            public LocalTime fromString(String string) {
                if (LocalTimeTextField.this.showSeconds.get()) {
                    return LocalTime.parse(string, FORMAT_WITH_SECONDS_PATTERN);
                }
                return LocalTime.parse(string, FORMAT_WITHOUT_SECONDS_PATTERN);
            }
        });
        this.setAlignment(Pos.CENTER);
        this.showSeconds.set(showSeconds);
    }

    public LocalTimeTextField(@Nonnull LocalTime time, boolean showSeconds) {
        super(LocalTimeTextField.timeToString(time, showSeconds));
        this.showSeconds.addListener(observable -> {
            this.timePattern = this.showSeconds.get() ? TIME_WITH_SECONDS_PATTERN : TIME_WITHOUT_SECONDS_PATTERN;
            this.setText(this.getText());
        });
        this.textProperty().bindBidirectional(this.timeProperty(), (StringConverter)new /* invalid duplicate definition of identical inner class */);
        this.setAlignment(Pos.CENTER);
        this.time.set((Object)time);
        this.showSeconds.set(showSeconds);
    }

    private static String timeToString(LocalTime time, boolean showSeconds) {
        if (showSeconds) {
            return time.format(FORMAT_WITH_SECONDS_PATTERN);
        }
        return time.format(FORMAT_WITHOUT_SECONDS_PATTERN);
    }

    public void setTime(LocalTime time) {
        this.time.set((Object)time);
        super.setText(LocalTimeTextField.timeToString(time, this.showSeconds.get()));
    }

    public LocalTime getTime() {
        return (LocalTime)this.time.get();
    }

    public ObjectProperty<LocalTime> timeProperty() {
        return this.time;
    }

    public boolean getShowSeconds() {
        return this.showSeconds.get();
    }

    public BooleanProperty showSecondsProperty() {
        return this.showSeconds;
    }

    public void setShowSeconds(boolean showSeconds) {
        this.showSeconds.set(showSeconds);
    }

    public void appendText(String text) {
    }

    public boolean deleteNextChar() {
        boolean success = false;
        IndexRange selection = this.getSelection();
        if (selection.getLength() > 0) {
            int selectionEnd = selection.getEnd();
            this.deleteText(selection);
            this.positionCaret(selectionEnd);
            this.skipSeparatorCharactersBackward();
            success = true;
        } else {
            int caret = this.getCaretPosition();
            if (caret % 3 != 2) {
                String currentText = this.getText();
                this.setText(currentText.substring(0, caret) + "0" + currentText.substring(caret + 1));
                success = true;
            }
            this.positionCaret(Math.min(caret + 1, this.getText().length()));
            this.skipSeparatorCharactersBackward();
        }
        return success;
    }

    public boolean deletePreviousChar() {
        boolean success = false;
        IndexRange selection = this.getSelection();
        if (selection.getLength() > 0) {
            int selectionStart = selection.getStart();
            this.deleteText(selection);
            this.positionCaret(selectionStart);
            this.skipSeparatorCharactersBackward();
            success = true;
        } else {
            int caret = this.getCaretPosition();
            if (caret % 3 != 0) {
                String currentText = this.getText();
                this.setText(currentText.substring(0, caret - 1) + "0" + currentText.substring(caret));
                success = true;
            }
            this.positionCaret(Math.max(caret - 1, 0));
            this.skipSeparatorCharactersBackward();
        }
        return success;
    }

    public void deleteText(IndexRange range) {
        this.deleteText(range.getStart(), range.getEnd());
    }

    public void deleteText(int begin, int end) {
        StringBuilder builder = new StringBuilder(this.getText());
        for (int c = begin; c < end; ++c) {
            if (c % 3 == 2) continue;
            builder.replace(c, c + 1, "0");
        }
        this.setText(builder.toString());
    }

    public void insertText(int index, String text) {
        StringBuilder builder = new StringBuilder(this.getText());
        builder.replace(index, index + text.length(), text);
        String testText = builder.toString();
        if (this.validate(testText)) {
            this.setText(testText);
            this.positionCaret(index + text.length());
            this.skipSeparatorCharactersForward();
        }
    }

    public void replaceSelection(String replacement) {
        IndexRange selection = this.getSelection();
        if (selection.getLength() == 0) {
            this.insertText(selection.getStart(), replacement);
        } else {
            this.replaceText(selection.getStart(), selection.getEnd(), replacement);
        }
    }

    public void replaceText(IndexRange range, String text) {
        this.replaceText(range.getStart(), range.getEnd(), text);
    }

    public void replaceText(int begin, int end, String text) {
        if (begin == end) {
            this.insertText(begin, text);
        } else if (text.length() == end - begin) {
            StringBuilder builder = new StringBuilder(this.getText());
            builder.replace(begin, end, text);
            String testText = builder.toString();
            if (this.validate(testText)) {
                this.setText(testText);
                this.positionCaret(end);
                this.skipSeparatorCharactersForward();
            }
        }
    }

    private boolean validate(String time) {
        if (!this.timePattern.matcher(time).matches()) {
            return false;
        }
        String[] tokens = time.split(":");
        try {
            int secs;
            int hours = Integer.parseInt(tokens[0]);
            if (hours < 0 || hours > 23) {
                return false;
            }
            int mins = Integer.parseInt(tokens[1]);
            if (mins < 0 || mins > 59) {
                return false;
            }
            return !this.showSeconds.get() || (secs = Integer.parseInt(tokens[2])) >= 0 && secs <= 59;
        }
        catch (NumberFormatException nfe) {
            assert (false);
            return false;
        }
    }

    private void skipSeparatorCharactersForward() {
        int pos = this.getCaretPosition();
        if (pos < this.getText().length() && Objects.equals(this.getText().substring(pos, pos + 1), ":")) {
            this.positionCaret(pos + 1);
        }
    }

    private void skipSeparatorCharactersBackward() {
        int pos = this.getCaretPosition();
        if (pos > 0 && Objects.equals(this.getText().substring(pos - 1, pos), ":")) {
            this.positionCaret(pos - 1);
        }
    }
}

