/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class PasswordInputDialog
extends Dialog<String> {
    private final GridPane grid;
    private final Label label;
    private final PasswordField passwordField;

    public PasswordInputDialog() {
        DialogPane dialogPane = this.getDialogPane();
        this.passwordField = new PasswordField();
        this.passwordField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.passwordField, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.passwordField, (Boolean)true);
        this.label = PasswordInputDialog.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.setTitle("Enter your password");
        dialogPane.setHeaderText("Please enter your password");
        dialogPane.getStyleClass().add((Object)"text-input-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? this.passwordField.getText() : null;
        });
    }

    static Label createContentLabel(String text) {
        Label label = new Label(text);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.getStyleClass().add((Object)"content");
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public final PasswordField getEditor() {
        return this.passwordField;
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add((Node)this.label, 0, 0);
        this.grid.add((Node)this.passwordField, 1, 0);
        this.getDialogPane().setContent((Node)this.grid);
        Platform.runLater(() -> ((PasswordField)this.passwordField).requestFocus());
    }
}

