/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.ui.AvailabilityMeter;
import be.iminds.ilabt.jfed.experimenter_gui.ui.HealthStatusPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCell
extends ListCell<Server> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceCell.class);
    private static final Comparator<? super MaintenanceInfo> MAINTENANCE_MESSAGE_COMPARATOR = Comparator.nullsLast(Comparator.comparing(MaintenanceInfo::getStart)).thenComparing(Comparator.nullsLast(Comparator.comparing(MaintenanceInfo::getEnd))).thenComparing(MaintenanceInfo::getMessage);
    private final JFedGuiConfig config;
    protected final HBox container = new HBox(2.0);
    protected final Label nameLabel = new Label("");
    protected final Glyph maintenanceIcon = GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.WRENCH, (Color)Color.RED);
    protected final Glyph reputationGlyph = GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.STAR, (Color)Color.GRAY);
    protected final Glyph healthStatusGlyph = GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.HEART, (Color)Color.GRAY);
    private final boolean shouldUseVMCalculationMethod;
    @Nullable
    protected final AvailabilityMeter availabilityMeter;
    protected boolean debug = false;
    @Nonnull
    private final StringConverter<Server> serverStringConverter;

    public ResourceCell(@Nullable ResourceClass resourceClass, @Nonnull JFedGuiConfig config, @Nullable StringConverter<Server> serverStringConverter) {
        this.config = config;
        this.serverStringConverter = serverStringConverter == null ? StringConverters.SERVER_STRING_CONVERTER : serverStringConverter;
        Pane fillerPane = new Pane();
        HBox.setHgrow((Node)fillerPane, (Priority)Priority.ALWAYS);
        this.container.setPadding(new Insets(0.0, 5.0, 2.0, 0.0));
        this.container.getChildren().addAll((Object[])new Node[]{this.nameLabel, fillerPane, this.maintenanceIcon});
        if (config.isShowReputationEnabled()) {
            this.container.getChildren().add((Object)this.reputationGlyph);
        }
        this.container.getChildren().add((Object)this.healthStatusGlyph);
        boolean shouldUseVMCalculationMethod = false;
        if (resourceClass != null) {
            if (config.getResourceType(resourceClass) == JFedGuiConfig.ResourceType.RAW_PC) {
                this.availabilityMeter = new AvailabilityMeter();
                this.container.getChildren().add((Object)this.availabilityMeter);
            } else if (config.getResourceType(resourceClass) == JFedGuiConfig.ResourceType.VM) {
                this.availabilityMeter = new AvailabilityMeter();
                shouldUseVMCalculationMethod = true;
                this.availabilityMeter.setUseVmCalculationMethod(true);
                this.container.getChildren().add((Object)this.availabilityMeter);
            } else {
                this.availabilityMeter = null;
            }
        } else {
            this.availabilityMeter = null;
        }
        this.setGraphic((Node)this.container);
        this.shouldUseVMCalculationMethod = shouldUseVMCalculationMethod;
    }

    protected void updateItem(Server item, boolean empty) {
        if (this.debug) {
            LOG.debug("ResourceCell.updateItem item=" + (item == null ? null : (Integer)item.getId()) + " empty=" + empty);
        }
        super.updateItem((Object)item, empty);
        if (!empty && item != null) {
            this.nameLabel.setText(this.serverStringConverter.toString((Object)item));
            ServerGlimpse serverGlimpse = this.config.getServerGlimpse(item);
            if (serverGlimpse != null) {
                ServerGlimpse.HealthInfo health = serverGlimpse.getHealthInfo();
                if (health != null && health.getHealth() != null) {
                    int healthPercent = health.getHealth();
                    if (healthPercent == 100) {
                        this.healthStatusGlyph.setTextFill((Paint)Color.GREEN);
                    } else if (healthPercent > 66) {
                        this.healthStatusGlyph.setTextFill((Paint)Color.YELLOWGREEN);
                    } else if (healthPercent > 33) {
                        this.healthStatusGlyph.setTextFill((Paint)Color.ORANGE);
                    } else {
                        this.healthStatusGlyph.setTextFill((Paint)Color.RED);
                    }
                    Tooltip.install((Node)this.healthStatusGlyph, (Tooltip)new Tooltip(String.format("%s has a health rating of %d%%", this.serverStringConverter.toString((Object)item), healthPercent)));
                    this.healthStatusGlyph.setVisible(true);
                } else {
                    this.healthStatusGlyph.setVisible(false);
                }
                if (serverGlimpse.getReputation() != null && this.config.isShowReputationEnabled()) {
                    int reputation = serverGlimpse.getReputation();
                    if (reputation > 95) {
                        this.reputationGlyph.setTextFill((Paint)Color.GREEN);
                    } else if (reputation > 66) {
                        this.reputationGlyph.setTextFill((Paint)Color.YELLOWGREEN);
                    } else if (reputation > 33) {
                        this.reputationGlyph.setTextFill((Paint)Color.ORANGE);
                    } else {
                        this.reputationGlyph.setTextFill((Paint)Color.RED);
                    }
                    Tooltip.install((Node)this.reputationGlyph, (Tooltip)new Tooltip(String.format("%s has a reputation rating of %d%%", this.serverStringConverter.toString((Object)item), reputation)));
                    this.reputationGlyph.setVisible(true);
                } else {
                    this.reputationGlyph.setVisible(false);
                }
                if (serverGlimpse.getMaintenance() != null) {
                    ZonedDateTime now = ZonedDateTime.now();
                    List<MaintenanceInfo> activeMaintenances = serverGlimpse.getMaintenance().stream().filter(mm -> mm.getStartTime() == null || mm.getStartTime().isBefore(now)).filter(mm -> mm.getEndTime() == null || mm.getEndTime().isAfter(now)).sorted(MAINTENANCE_MESSAGE_COMPARATOR).collect(Collectors.toList());
                    List<MaintenanceInfo> futureMaintenances = serverGlimpse.getMaintenance().stream().filter(mm -> mm.getStartTime() != null && mm.getStartTime().isAfter(now)).sorted(MAINTENANCE_MESSAGE_COMPARATOR).collect(Collectors.toList());
                    if (!activeMaintenances.isEmpty()) {
                        Tooltip.install((Node)this.maintenanceIcon, (Tooltip)new Tooltip(HealthStatusPane.formatMaintenanceInfos(activeMaintenances)));
                        this.maintenanceIcon.setTextFill((Paint)Color.RED);
                        this.maintenanceIcon.setVisible(true);
                    } else if (!futureMaintenances.isEmpty()) {
                        Tooltip.install((Node)this.maintenanceIcon, (Tooltip)new Tooltip(HealthStatusPane.formatMaintenanceInfos(futureMaintenances)));
                        this.maintenanceIcon.setTextFill((Paint)Color.ORANGE);
                        this.maintenanceIcon.setVisible(true);
                    } else {
                        this.maintenanceIcon.setVisible(false);
                    }
                } else {
                    this.maintenanceIcon.setVisible(false);
                }
                ServerGlimpse.AdvertisementInfo advInf = serverGlimpse.getAdvertisementInfo();
                if (advInf != null && this.availabilityMeter != null) {
                    Integer rawAvail = advInf.getCount(AdvertisementCounts.CountedObject.RAW_PC, AdvertisementCounts.CountScope.AVAILABLE);
                    Integer rawTotal = advInf.getCount(AdvertisementCounts.CountedObject.RAW_PC, AdvertisementCounts.CountScope.ALL);
                    Integer vmAvail = advInf.getCount(AdvertisementCounts.CountedObject.VM, AdvertisementCounts.CountScope.AVAILABLE);
                    Integer vmTotal = advInf.getCount(AdvertisementCounts.CountedObject.VM, AdvertisementCounts.CountScope.ALL);
                    Integer anyAvail = advInf.getCount(AdvertisementCounts.CountedObject.ANY, AdvertisementCounts.CountScope.AVAILABLE);
                    Integer anyTotal = advInf.getCount(AdvertisementCounts.CountedObject.ANY, AdvertisementCounts.CountScope.ALL);
                    if (this.shouldUseVMCalculationMethod && vmAvail != null && vmTotal != null && vmTotal != 0) {
                        this.availabilityMeter.setUseVmCalculationMethod(true);
                        this.availabilityMeter.setAvailable(vmAvail);
                        this.availabilityMeter.setTotal(vmTotal);
                        this.availabilityMeter.setVisible(true);
                        this.availabilityMeter.setUndetermined(false);
                        Tooltip.install((Node)this.availabilityMeter, (Tooltip)new Tooltip(vmAvail + " of " + vmTotal + " VM available"));
                    } else {
                        this.availabilityMeter.setUseVmCalculationMethod(false);
                        if (rawAvail != null && rawTotal != null && rawTotal != 0) {
                            this.availabilityMeter.setAvailable(rawAvail);
                            this.availabilityMeter.setTotal(rawTotal);
                            this.availabilityMeter.setVisible(true);
                            this.availabilityMeter.setUndetermined(false);
                            Tooltip.install((Node)this.availabilityMeter, (Tooltip)new Tooltip(rawAvail + " of " + rawTotal + " bare metal available"));
                            this.availabilityMeter.setVisible(true);
                        } else if (anyAvail != null && anyTotal != null && anyTotal != 0) {
                            this.availabilityMeter.setAvailable(anyAvail);
                            this.availabilityMeter.setTotal(anyTotal);
                            this.availabilityMeter.setVisible(true);
                            this.availabilityMeter.setUndetermined(false);
                            Tooltip.install((Node)this.availabilityMeter, (Tooltip)new Tooltip(anyAvail + " of " + anyTotal + " resources available"));
                        } else {
                            this.availabilityMeter.setAvailable(0);
                            this.availabilityMeter.setTotal(0);
                            this.availabilityMeter.setVisible(true);
                            this.availabilityMeter.setUndetermined(true);
                        }
                    }
                }
            } else {
                this.healthStatusGlyph.setVisible(false);
                this.reputationGlyph.setVisible(false);
                this.maintenanceIcon.setVisible(false);
                if (this.availabilityMeter != null) {
                    this.availabilityMeter.setVisible(false);
                }
            }
        } else {
            this.nameLabel.setText("");
            this.healthStatusGlyph.setVisible(false);
            this.reputationGlyph.setVisible(false);
            this.maintenanceIcon.setVisible(false);
            if (this.availabilityMeter != null) {
                this.availabilityMeter.setVisible(false);
            }
        }
    }
}

