/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import be.iminds.ilabt.jfed.experimenter_gui.config.TestbedSiteInfo;
import be.iminds.ilabt.jfed.experimenter_gui.ui.AvailabilityMeter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import java.util.Comparator;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedSiteCell
extends ListCell<TestbedSiteInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedSiteCell.class);
    private static final Comparator<? super MaintenanceInfo> MAINTENANCE_MESSAGE_COMPARATOR = Comparator.nullsLast(Comparator.comparing(MaintenanceInfo::getStart)).thenComparing(Comparator.nullsLast(Comparator.comparing(MaintenanceInfo::getEnd))).thenComparing(MaintenanceInfo::getMessage);
    protected final HBox container = new HBox(2.0);
    protected final Label nameLabel = new Label("");
    @Nonnull
    protected final AvailabilityMeter availabilityMeter;
    protected boolean debug = false;

    public TestbedSiteCell() {
        Pane fillerPane = new Pane();
        HBox.setHgrow((Node)fillerPane, (Priority)Priority.ALWAYS);
        this.availabilityMeter = new AvailabilityMeter();
        this.container.setPadding(new Insets(0.0, 5.0, 2.0, 0.0));
        this.container.getChildren().add((Object)this.nameLabel);
        this.container.getChildren().add((Object)this.availabilityMeter);
        this.setGraphic((Node)this.container);
    }

    protected void updateItem(TestbedSiteInfo item, boolean empty) {
        if (this.debug) {
            LOG.debug("TestbedSiteCell.updateItem hrn=" + (item == null ? null : item.getHrn()) + " empty=" + empty);
        }
        super.updateItem((Object)item, empty);
        if (!empty && item != null) {
            this.nameLabel.setText(item.getHrn());
            if (item.getAvailableComponents() == -1 || item.getAvailableComponents() == -1) {
                this.availabilityMeter.setVisible(false);
            } else {
                this.availabilityMeter.setAvailable(item.getAvailableComponents());
                this.availabilityMeter.setTotal(item.getTotalComponents());
                this.availabilityMeter.setVisible(true);
                this.availabilityMeter.setUndetermined(false);
                Tooltip.install((Node)this.availabilityMeter, (Tooltip)new Tooltip(item.getAvailableComponents() + " of " + item.getTotalComponents() + " resources available"));
            }
        } else {
            this.nameLabel.setText("");
            this.availabilityMeter.setVisible(false);
        }
    }
}

