/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui;

import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportComposer;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.util.SentryUtil;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.ExceptionUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.name.Named;
import io.dropwizard.jackson.Jackson;
import io.sentry.Sentry;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Provider;
import org.controlsfx.dialog.ExceptionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncaughtGuiExceptionToBugReport
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UncaughtGuiExceptionToBugReport.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private final Provider<BugReportComposer> bugReportComposerProvider;
    private final Provider<FedmonWebApiClientConfig> fedmonWebApiClientConfigProvider;
    private final Provider<TaskService> taskServiceProvider;
    private final SfaModel sfaModel;
    private final JFedPreferences jFedPreferences;
    private Stage stage;

    @Inject
    public UncaughtGuiExceptionToBugReport(Provider<BugReportComposer> bugReportComposerProvider, @Named(value="clientAuthWebApiConfig") Provider<FedmonWebApiClientConfig> fedmonWebApiClientConfigProvider, Provider<TaskService> taskServiceProvider, SfaModel sfaModel, JFedPreferences jFedPreferences) {
        this.bugReportComposerProvider = bugReportComposerProvider;
        this.fedmonWebApiClientConfigProvider = fedmonWebApiClientConfigProvider;
        this.taskServiceProvider = taskServiceProvider;
        this.sfaModel = sfaModel;
        this.jFedPreferences = jFedPreferences;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    @Override
    public void uncaughtException(Thread t, Throwable uncaughtThrowable) {
        LOG.error("UNCAUGHT ERROR IN THREAD {}", (Object)t.getName(), (Object)uncaughtThrowable);
        try {
            for (StackTraceElement ste : uncaughtThrowable.getStackTrace()) {
                if (!ste.getClassName().contains(UncaughtGuiExceptionToBugReport.class.getSimpleName())) continue;
                LOG.error("DETECTED CYCLE IN UNCAUGHT ERROR. WILL ABORT!", uncaughtThrowable);
                return;
            }
        }
        catch (Throwable cycleDetectEx) {
            LOG.error("ERROR IN CYCLE DETECTION. WILL ABORT!", cycleDetectEx);
            return;
        }
        Platform.runLater(() -> {
            block14: {
                try {
                    if (ExceptionUtil.isOutOfMemory((Throwable)uncaughtThrowable)) {
                        if (this.stage != null) {
                            try {
                                Optional reply = JFDialogs.create().owner((Window)this.stage).message("jFed has run out of memory. This will cause bugs and instabilities.\nIt is advised to close jFed now and restart it.\n\nYou can choose to continue. You might still be able to save your work.\n\nContinue running jFed?").masthead("Out of Memory!").buttonTypes(new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL}).showWarning();
                                if (reply.isPresent() && Objects.equals(reply.get(), ButtonType.YES)) {
                                    LOG.warn("User chose to continue after out of memory.");
                                    break block14;
                                }
                                LOG.warn("User chose to exit after out of memory.");
                                System.exit(-1);
                            }
                            catch (Throwable throwable) {
                                System.err.println("jFed encountered an exception trying to handle OutOfMemoryError dialog. Will exit.");
                                LOG.error("jFed encountered an exception trying to handle OutOfMemoryError dialog. Will exit.", throwable);
                                System.exit(-1);
                            }
                            break block14;
                        }
                        System.err.println("jFed ran out of memory and will exit.");
                        LOG.warn("jFed ran out of memory and will exit.", uncaughtThrowable);
                        System.exit(-1);
                        break block14;
                    }
                    if (ExceptionUtil.isOutOfDiskSpace((Throwable)uncaughtThrowable)) {
                        try {
                            JFDialogs.create().owner((Window)this.stage).message("You ran out of disk space. This caused a jFed action to fail.\nIt is advised to free up disk space before continuing to use jFed.\n").masthead("Out of Disk Space!").buttonTypes(new ButtonType[]{ButtonType.OK}).showWarning();
                        }
                        catch (Throwable throwable) {
                            System.err.println("jFed encountered an exception trying to handle out of disk space dialog. Will ignore.");
                            LOG.error("jFed encountered an exception trying to handle out of disk space dialog. Will ignore.", throwable);
                        }
                    } else {
                        try {
                            ExceptionDialog exceptionDialog = new ExceptionDialog(uncaughtThrowable);
                            if (this.stage != null) {
                                exceptionDialog.initOwner((Window)this.stage);
                            }
                            exceptionDialog.setHeaderText("Unexpected error");
                            VBox contentPane = new VBox(10.0);
                            contentPane.setPrefWidth(600.0);
                            Label sorryLabel = new Label("We're sorry");
                            sorryLabel.setFont(Font.font((String)Font.getDefault().getFamily(), (FontWeight)FontWeight.BOLD, (double)Font.getDefault().getSize()));
                            Label infoLabel = new Label("jFed detected an unexpected error, which can likely cause bugs and instabilities. If you experience these, we recommend restarting jFed.");
                            infoLabel.setWrapText(true);
                            CheckBox sendBugreportCheckbox = new CheckBox("Tell jFed developers about this error, so they can fix it");
                            sendBugreportCheckbox.setWrapText(true);
                            sendBugreportCheckbox.setSelected(true);
                            TextArea descriptionTextArea = new TextArea();
                            descriptionTextArea.setPromptText("Optional: add extra info");
                            descriptionTextArea.setStyle("-fx-margin: 0 0 0 30px");
                            descriptionTextArea.setPrefRowCount(3);
                            contentPane.getChildren().addAll((Object[])new Node[]{sorryLabel, infoLabel, sendBugreportCheckbox, descriptionTextArea});
                            exceptionDialog.getDialogPane().setContent((Node)contentPane);
                            Platform.runLater(() -> {
                                if (exceptionDialog.showAndWait().isPresent() && sendBugreportCheckbox.isSelected()) {
                                    LOG.info("Sending uncaught exception to Sentry");
                                    try {
                                        Sentry.setExtra((String)"slices", (String)MAPPER.writeValueAsString((Object)SentryUtil.createSentrySlices((SfaModel)this.sfaModel)));
                                    }
                                    catch (JsonProcessingException e) {
                                        Sentry.setExtra((String)"slices", (String)("Failed to write to JSON: " + e.getMessage()));
                                    }
                                    Sentry.setExtra((String)"preferences", (String)be.iminds.ilabt.jfed.util.sentry.SentryUtil.createSentryPreferences((JFedPreferences)this.jFedPreferences));
                                    if (descriptionTextArea.getText().trim().length() >= 2) {
                                        Sentry.setExtra((String)"user_feedback_comment", (String)descriptionTextArea.getText());
                                        Sentry.captureException((Throwable)uncaughtThrowable);
                                        Sentry.removeExtra((String)"user_feedback_comment");
                                    } else {
                                        Sentry.captureException((Throwable)uncaughtThrowable);
                                    }
                                    Sentry.removeExtra((String)"slices");
                                    Sentry.removeExtra((String)"preferences");
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            System.err.println("jFed encountered an exception trying to handle Error dialog. (inner)");
                            LOG.error("jFed encountered an exception trying to handle Error dialog. (inner)", throwable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Sentry.captureException((Throwable)throwable);
                    System.err.println("jFed encountered an exception trying to handle Error dialog. (outer)");
                    LOG.error("jFed encountered an exception trying to handle Error dialog. (outer)", throwable);
                }
            }
        });
    }
}

