/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui.code;

import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.util.Objects;
import javafx.scene.layout.StackPane;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebView;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlCodeView
extends StackPane {
    private static final Logger LOG = LoggerFactory.getLogger(XmlCodeView.class);
    private final WebView webView = new WebView();
    private final String editingTemplate = "<!doctype html><html><head>  <link rel=\"stylesheet\" href=\"" + XmlCodeView.class.getResource("codemirror.css").toExternalForm() + "\">  <link rel=\"stylesheet\" href=\"" + XmlCodeView.class.getResource("dialog.css").toExternalForm() + "\">  <link rel=\"stylesheet\" href=\"" + XmlCodeView.class.getResource("matchesonscrollbar.css").toExternalForm() + "\">  <script src=\"" + XmlCodeView.class.getResource("codemirror.js").toExternalForm() + "\"></script>  <script src=\"" + XmlCodeView.class.getResource("dialog.js").toExternalForm() + "\"></script>  <script src=\"" + XmlCodeView.class.getResource("jump-to-line.js").toExternalForm() + "\"></script>  <script src=\"" + XmlCodeView.class.getResource("match-highlighter.js").toExternalForm() + "\"></script>  <script src=\"" + XmlCodeView.class.getResource("matchesonscrollbar.js").toExternalForm() + "\"></script>  <script src=\"" + XmlCodeView.class.getResource("search.js").toExternalForm() + "\"></script>  <script src=\"" + XmlCodeView.class.getResource("searchcursor.js").toExternalForm() + "\"></script>  <script src=\"" + XmlCodeView.class.getResource("xml.js").toExternalForm() + "\"></script></head><body><form><textarea id=\"code\" name=\"code\" class=\"code\">\n${code}</textarea></form><script>  var editor = CodeMirror.fromTextArea(document.getElementById(\"code\"), {    lineNumbers: true,    htmlMode: false,    lineWrapping: true,    autofocus: true,    readOnly: ${readOnly},    mode: \"application/xml\",    viewportMargin: Infinity  });</script></body></html>";
    private String content;
    private boolean editable;

    public XmlCodeView() {
        this(null);
    }

    public XmlCodeView(String content) {
        this(content, true);
    }

    public XmlCodeView(String content, boolean editable) {
        this.webView.setFontSmoothingType(FontSmoothingType.LCD);
        this.getChildren().add((Object)this.webView);
        this.editable = true;
        this.content = content;
        this.editable = editable;
        this.updateView();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.updateView();
    }

    private void updateView() {
        String editorContent = this.editingTemplate.replace("${code}", this.content != null ? StringEscapeUtils.escapeHtml((String)this.content) : "").replace("${readOnly}", this.editable ? "false" : "true");
        this.webView.getEngine().loadContent(editorContent);
    }

    public String getContent() {
        if (this.webView.getEngine().getLoadWorker().isRunning()) {
            return this.content;
        }
        return (String)this.webView.getEngine().executeScript("editor.getValue();");
    }

    public void setContent(String content) {
        this.content = content;
        this.updateView();
    }

    public boolean formatXmlCode() {
        String currentContent = this.getContent();
        String formattedContent = XmlUtil.formatXmlFromString_alwaysSafe((String)currentContent);
        if (formattedContent != null) {
            this.setContent(formattedContent);
            return true;
        }
        return false;
    }

    public void showSearch() {
        this.webView.getEngine().executeScript("CodeMirror.commands.find(editor);");
    }

    public void showReplace() {
        this.webView.getEngine().executeScript("CodeMirror.commands.replace(editor);");
    }

    public boolean isDirty() {
        return !Objects.equals(this.getContent(), this.content);
    }
}

