/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar;

import be.iminds.ilabt.jfed.experimenter_gui.ExperimenterGUI;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportToServerTask;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.SaveManifestAction;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.DeleteDiskImageTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTask;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.TaskProgressView;
import org.controlsfx.glyphfont.FontAwesome;

public class TasksProgressIndicator
extends HBox {
    private final Label progressLabel = new Label();
    private final ProgressBar progressBar = new ProgressBar();
    private final PopOver popOver = new PopOver();
    private final TaskProgressView<Task<?>> taskProgressView = new TaskProgressView();
    private final InvalidationListener progressInvalidationListener = invalidated -> this.progressBar.setProgress(this.taskProgressView.getTasks().stream().mapToDouble(Task::getProgress).average().orElse(0.0));

    public TasksProgressIndicator() {
        this.setAlignment(Pos.CENTER);
        this.setVisible(false);
        this.setSpacing(5.0);
        this.progressBar.setProgress(0.0);
        this.progressBar.setPrefWidth(100.0);
        this.getChildren().addAll((Object[])new Node[]{this.progressLabel, this.progressBar});
        HBox.setHgrow((Node)this.progressBar, (Priority)Priority.ALWAYS);
        this.popOver.setContentNode(this.taskProgressView);
        this.popOver.setArrowLocation(PopOver.ArrowLocation.BOTTOM_RIGHT);
        this.popOver.setAutoHide(true);
        this.taskProgressView.setGraphicFactory(task -> {
            if (task instanceof RecoverSliceTask) {
                return GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.AMBULANCE, (Color)Color.GREEN);
            }
            if (task instanceof DeleteDiskImageTask) {
                return GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES, (Color)Color.RED);
            }
            if (task instanceof SaveManifestAction.SaveManifestTask) {
                return GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.SAVE, (Color)Color.BLUE);
            }
            if (task instanceof SaveManifestAction.SaveCSVTask) {
                return GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.SAVE, (Color)Color.ORANGERED);
            }
            if (task instanceof ExperimenterGUI.CreateExperimentTask) {
                return GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PLAY, (Color)Color.GREEN);
            }
            if (task instanceof BugReportToServerTask) {
                return GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.BUG, (Color)Color.ORANGE);
            }
            return null;
        });
        this.progressBar.setOnMouseEntered(event -> {
            if (!this.taskProgressView.getTasks().isEmpty()) {
                Point2D locationOnScreen = this.localToScreen(this.getWidth() / 2.0, 0.0);
                this.popOver.show((Node)this, locationOnScreen.getX(), locationOnScreen.getY(), Duration.seconds((double)0.5));
            }
        });
        this.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.taskProgressView.getTasks()));
        this.taskProgressView.prefHeightProperty().bind((ObservableValue)Bindings.min((int)300, (ObservableNumberValue)Bindings.size((ObservableList)this.taskProgressView.getTasks()).multiply(70)));
        this.taskProgressView.getTasks().addListener(observable -> Platform.runLater(this::updateText));
        this.taskProgressView.getTasks().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                for (Task t : c.getAddedSubList()) {
                    t.progressProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.progressInvalidationListener));
                }
            }
        });
    }

    private void updateText() {
        if (this.taskProgressView.getTasks().size() == 1) {
            Task task = (Task)this.taskProgressView.getTasks().get(0);
            this.progressLabel.setText(task.getTitle());
        } else {
            this.progressLabel.setText(String.format("%d tasks running", this.taskProgressView.getTasks().size()));
        }
    }

    public void followTaskProgress(Task<?> task) {
        this.taskProgressView.getTasks().add(task);
    }
}

