/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon;

import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonButton;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonComponentGroup;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonTab;
import be.iminds.ilabt.jfed.highlevel.util.ExecuteOnNotNull;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RibbonBar
extends TabPane {
    private static final Logger LOG = LoggerFactory.getLogger(RibbonBar.class);
    public static final String STYLESHEET_URL = "ribbon.css";
    private static final String RIBBON_STYLE = "ribbon-tabpane";

    public RibbonBar() {
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(STYLESHEET_URL).toExternalForm());
        this.getStyleClass().add((Object)RIBBON_STYLE);
        new ExecuteOnNotNull<Scene>(this.sceneProperty()){

            public void run() {
                for (Tab tab : RibbonBar.this.getTabs()) {
                    assert (tab instanceof RibbonTab);
                    RibbonBar.this.registerAcceleratorsOfRibbonTab((RibbonTab)tab, false);
                }
                RibbonBar.this.getTabs().addListener(change -> {
                    while (change.next()) {
                        if (change.wasAdded()) {
                            for (Tab tab : change.getAddedSubList()) {
                                assert (tab instanceof RibbonTab);
                                RibbonBar.this.registerAcceleratorsOfRibbonTab((RibbonTab)tab, false);
                            }
                        }
                        if (!change.wasRemoved()) continue;
                        for (Tab tab : change.getRemoved()) {
                            assert (tab instanceof RibbonTab);
                            RibbonBar.this.unregisterAcceleratorsOfRibbonTab((RibbonTab)tab, false);
                        }
                    }
                });
                assert (RibbonBar.this.getSelectionModel().getSelectedItem() instanceof RibbonTab);
                RibbonBar.this.registerAcceleratorsOfRibbonTab((RibbonTab)((Object)RibbonBar.this.getSelectionModel().getSelectedItem()), true);
                RibbonBar.this.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                    if (oldValue != null) {
                        assert (oldValue instanceof RibbonTab);
                        RibbonBar.this.unregisterAcceleratorsOfRibbonTab((RibbonTab)((Object)oldValue), true);
                    }
                    if (newValue != null) {
                        assert (newValue instanceof RibbonTab);
                        RibbonBar.this.registerAcceleratorsOfRibbonTab((RibbonTab)((Object)newValue), true);
                    }
                });
            }
        };
    }

    private void registerAcceleratorsOfRibbonTab(RibbonTab ribbonTab, boolean onlyWhenVisible) {
        for (Node node : ribbonTab.getGroups()) {
            assert (node instanceof RibbonComponentGroup);
            RibbonComponentGroup ribbonComponentGroup = (RibbonComponentGroup)node;
            ribbonComponentGroup.getButtonChildren().stream().filter(buttonNode -> buttonNode instanceof RibbonButton).map(buttonNode -> (RibbonButton)buttonNode).filter(rb -> rb.getAccelerator() != null).filter(rb -> rb.getAcceleratorOnlyWhenVisible() == onlyWhenVisible).forEach(rb -> {
                if (this.getScene().getAccelerators().containsKey((Object)rb.getAccelerator())) {
                    LOG.warn("Accelerator {} is already defined in scene!", (Object)rb.getAccelerator());
                }
                this.getScene().getAccelerators().put((Object)rb.getAccelerator(), rb);
            });
        }
    }

    private void unregisterAcceleratorsOfRibbonTab(RibbonTab ribbonTab, boolean onlyWhenVisible) {
        for (Node node : ribbonTab.getGroups()) {
            assert (node instanceof RibbonComponentGroup);
            RibbonComponentGroup ribbonComponentGroup = (RibbonComponentGroup)node;
            ribbonComponentGroup.getButtonChildren().stream().filter(buttonNode -> buttonNode instanceof RibbonButton).map(buttonNode -> (RibbonButton)buttonNode).filter(rb -> rb.getAccelerator() != null).filter(rb -> rb.getAcceleratorOnlyWhenVisible() == onlyWhenVisible).forEach(rb -> {
                assert (this.getScene() != null);
                assert (this.getScene().getAccelerators() != null);
                assert (this.getScene().getAccelerators().get((Object)rb.getAccelerator()) == rb) : "accelerator registration mismatch for " + rb.getAccelerator().getDisplayText() + "  <-> " + String.valueOf(this.getScene().getAccelerators().get((Object)rb.getAccelerator()));
                this.getScene().getAccelerators().remove((Object)rb.getAccelerator());
            });
        }
    }
}

