/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RibbonButton
extends BorderPane
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RibbonButton.class);
    private static final double BIG_ICON_SIZE = 24.0;
    private final ObjectProperty<KeyCombination> accelerator = new SimpleObjectProperty();
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty();
    private final StringProperty text = new SimpleStringProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty();
    private final BooleanProperty acceleratorOnlyWhenVisible = new SimpleBooleanProperty();
    private final VBox textContainer = new VBox();
    private final Label line1Label = new Label();
    protected final HBox secondLineContainer = new HBox();
    private final Label line2Label = new Label();

    public RibbonButton() {
        this.getStyleClass().add((Object)"ribbon-button");
        this.line1Label.getStyleClass().add((Object)"ribbon-button-text");
        this.line2Label.getStyleClass().add((Object)"ribbon-button-text");
        this.secondLineContainer.setAlignment(Pos.CENTER);
        this.secondLineContainer.getChildren().add((Object)this.line2Label);
        this.textContainer.getStyleClass().add((Object)"ribbon-button-textcontainer");
        this.textContainer.getChildren().addAll((Object[])new Node[]{this.line1Label, this.secondLineContainer});
        this.setBottom((Node)this.textContainer);
        this.text.addListener(observable -> {
            String newText = (String)this.text.get();
            if (newText != null) {
                String[] lines = newText.split("\n");
                this.line1Label.setText(lines.length > 0 ? lines[0] : "");
                this.line2Label.setText(lines.length > 1 ? lines[1] : "");
            } else {
                this.line1Label.setText("");
                this.line2Label.setText("");
            }
        });
        this.graphic.addListener(observable -> {
            if (this.graphic.get() != null) {
                ((Node)this.graphic.get()).getStyleClass().add((Object)"ribbon-button-graphic");
                if (this.graphic.get() instanceof Glyph) {
                    ((Glyph)this.graphic.get()).setFontSize(24.0);
                }
            }
            this.setCenter((Node)this.graphic.get());
        });
        this.setOnMouseClicked(mouseEvent -> {
            if (this.onAction.get() != null) {
                ((EventHandler)this.onAction.get()).handle((Event)new ActionEvent());
            }
        });
    }

    public RibbonButton(String s) {
        this.getStyleClass().add((Object)"ribbon-button");
        this.line1Label.getStyleClass().add((Object)"ribbon-button-text");
        this.line2Label.getStyleClass().add((Object)"ribbon-button-text");
        this.secondLineContainer.setAlignment(Pos.CENTER);
        this.secondLineContainer.getChildren().add((Object)this.line2Label);
        this.textContainer.getStyleClass().add((Object)"ribbon-button-textcontainer");
        this.textContainer.getChildren().addAll((Object[])new Node[]{this.line1Label, this.secondLineContainer});
        this.setBottom((Node)this.textContainer);
        this.text.addListener(observable -> {
            String newText = (String)this.text.get();
            if (newText != null) {
                String[] lines = newText.split("\n");
                this.line1Label.setText(lines.length > 0 ? lines[0] : "");
                this.line2Label.setText(lines.length > 1 ? lines[1] : "");
            } else {
                this.line1Label.setText("");
                this.line2Label.setText("");
            }
        });
        this.graphic.addListener(observable -> {
            if (this.graphic.get() != null) {
                ((Node)this.graphic.get()).getStyleClass().add((Object)"ribbon-button-graphic");
                if (this.graphic.get() instanceof Glyph) {
                    ((Glyph)this.graphic.get()).setFontSize(24.0);
                }
            }
            this.setCenter((Node)this.graphic.get());
        });
        this.setOnMouseClicked(mouseEvent -> {
            if (this.onAction.get() != null) {
                ((EventHandler)this.onAction.get()).handle((Event)new ActionEvent());
            }
        });
        this.setText(s);
    }

    public RibbonButton(String s, Node node) {
        this.getStyleClass().add((Object)"ribbon-button");
        this.line1Label.getStyleClass().add((Object)"ribbon-button-text");
        this.line2Label.getStyleClass().add((Object)"ribbon-button-text");
        this.secondLineContainer.setAlignment(Pos.CENTER);
        this.secondLineContainer.getChildren().add((Object)this.line2Label);
        this.textContainer.getStyleClass().add((Object)"ribbon-button-textcontainer");
        this.textContainer.getChildren().addAll((Object[])new Node[]{this.line1Label, this.secondLineContainer});
        this.setBottom((Node)this.textContainer);
        this.text.addListener(observable -> {
            String newText = (String)this.text.get();
            if (newText != null) {
                String[] lines = newText.split("\n");
                this.line1Label.setText(lines.length > 0 ? lines[0] : "");
                this.line2Label.setText(lines.length > 1 ? lines[1] : "");
            } else {
                this.line1Label.setText("");
                this.line2Label.setText("");
            }
        });
        this.graphic.addListener(observable -> {
            if (this.graphic.get() != null) {
                ((Node)this.graphic.get()).getStyleClass().add((Object)"ribbon-button-graphic");
                if (this.graphic.get() instanceof Glyph) {
                    ((Glyph)this.graphic.get()).setFontSize(24.0);
                }
            }
            this.setCenter((Node)this.graphic.get());
        });
        this.setOnMouseClicked(mouseEvent -> {
            if (this.onAction.get() != null) {
                ((EventHandler)this.onAction.get()).handle((Event)new ActionEvent());
            }
        });
        this.setText(s);
        this.setGraphic(node);
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onAction.get();
    }

    public void setOnAction(EventHandler<ActionEvent> onAction) {
        this.onAction.set(onAction);
    }

    public boolean getAcceleratorOnlyWhenVisible() {
        return this.acceleratorOnlyWhenVisible.get();
    }

    public void setAcceleratorOnlyWhenVisible(boolean acceleratorOnlyWhenVisible) {
        this.acceleratorOnlyWhenVisible.set(acceleratorOnlyWhenVisible);
    }

    public BooleanProperty acceleratorOnlyWhenVisibleProperty() {
        return this.acceleratorOnlyWhenVisible;
    }

    public KeyCombination getAccelerator() {
        return (KeyCombination)this.accelerator.get();
    }

    public void setAccelerator(KeyCombination accelerator) {
        this.accelerator.set((Object)accelerator);
    }

    public ObjectProperty<KeyCombination> acceleratorProperty() {
        return this.accelerator;
    }

    public String getText() {
        return (String)this.text.get();
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public Node getGraphic() {
        return (Node)this.graphic.get();
    }

    public void setGraphic(Node graphic) {
        this.graphic.set((Object)graphic);
    }

    public ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public boolean isSmall() {
        return false;
    }

    public void setSmall(boolean value) {
    }

    @Override
    public void run() {
        if (this.onAction.get() != null) {
            ((EventHandler)this.onAction.get()).handle((Event)new ActionEvent());
        }
    }
}

