/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon;

import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonButton;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonToggleButton;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class RibbonComponentGroup
extends VBox {
    private final ObservableList<Node> buttonChildren = FXCollections.observableArrayList();
    private static final int MAX_VERTICAL_SMALL_BUTTONS = 2;
    private int columnIndex = 0;
    private int rowIndex = 0;
    @FXML
    private GridPane buttonPane;
    @FXML
    private Label label;

    public RibbonComponentGroup() {
        FXMLUtil.injectFXML((Object)((Object)this));
        this.buttonChildren.addListener(change -> {
            while (change.next()) {
                for (Node node : change.getAddedSubList()) {
                    boolean small = false;
                    if (node instanceof RibbonButton) {
                        small = ((RibbonButton)node).isSmall();
                    } else if (node instanceof RibbonToggleButton) {
                        small = ((RibbonToggleButton)node).isSmall();
                    }
                    if (!small && this.rowIndex > 0) {
                        ++this.columnIndex;
                        this.rowIndex = 0;
                    }
                    if (small) {
                        this.buttonPane.add(node, this.columnIndex, this.rowIndex);
                    } else {
                        this.buttonPane.add(node, this.columnIndex, this.rowIndex, 1, 2);
                    }
                    if (small) {
                        ++this.rowIndex;
                        if (this.rowIndex != 2) continue;
                        ++this.columnIndex;
                        this.rowIndex = 0;
                        continue;
                    }
                    ++this.columnIndex;
                    this.rowIndex = 0;
                }
                for (Node node : change.getRemoved()) {
                    this.buttonPane.getChildren().remove((Object)node);
                }
            }
        });
    }

    public GridPane getButtonPane() {
        return this.buttonPane;
    }

    public Label getLabel() {
        return this.label;
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public void setLabelText(String text) {
        this.label.setText(text);
    }

    public ObservableList<Node> getButtonChildren() {
        return this.buttonChildren;
    }

    public String toString() {
        return "RibbonComponentGroup{buttonPane=" + String.valueOf(this.buttonPane) + ", label=" + String.valueOf(this.label) + "}";
    }
}

