/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ui.status;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

public class TaskStatusIndicator
extends StackPane
implements ChangeListener<Status> {
    private static final Image imageInactive = new Image(TaskStatusIndicator.class.getResourceAsStream("/images/16/task-accepted.png"));
    private static final Image imageSuccess = new Image(TaskStatusIndicator.class.getResourceAsStream("/images/16/task-complete.png"));
    private static final Image imageFail = new Image(TaskStatusIndicator.class.getResourceAsStream("/images/16/task-reject.png"));
    private static final Image imageWarning = new Image(TaskStatusIndicator.class.getResourceAsStream("/images/16/task-attempt.png"));
    private final ProgressIndicator progressIndicator;
    private final ImageView imageView;
    private final ObjectProperty<Status> status = new SimpleObjectProperty((Object)Status.INACTIVE);

    public TaskStatusIndicator() {
        this.setPrefHeight(16.0);
        this.setPrefWidth(16.0);
        this.progressIndicator = new ProgressIndicator();
        this.progressIndicator.setProgress(-1.0);
        this.progressIndicator.setVisible(false);
        this.imageView = new ImageView();
        this.imageView.setImage(imageInactive);
        this.getChildren().addAll((Object[])new Node[]{this.imageView, this.progressIndicator});
        this.statusProperty().addListener((ChangeListener)this);
        this.progressIndicator.setOnMouseClicked(mouseEvent -> {
            if (this.getOnMouseClicked() != null) {
                this.getOnMouseClicked().handle(mouseEvent);
            }
        });
    }

    public TaskStatusIndicator(Status status) {
        this();
        this.setStatus(status);
    }

    public Status getStatus() {
        return (Status)((Object)this.status.get());
    }

    public void setStatus(Status status) {
        this.status.set((Object)status);
    }

    public ObjectProperty<Status> statusProperty() {
        return this.status;
    }

    public void changed(ObservableValue<? extends Status> observableValue, Status oldValue, Status newValue) {
        if (newValue == Status.BUSY) {
            this.imageView.setVisible(false);
            this.progressIndicator.setVisible(true);
        } else {
            this.imageView.setVisible(true);
            this.progressIndicator.setVisible(false);
            switch (newValue.ordinal()) {
                case 0: {
                    this.imageView.setImage(imageInactive);
                    break;
                }
                case 2: {
                    this.imageView.setImage(imageSuccess);
                    break;
                }
                case 4: {
                    this.imageView.setImage(imageWarning);
                    break;
                }
                default: {
                    this.imageView.setImage(imageFail);
                }
            }
        }
    }

    public static enum Status {
        INACTIVE,
        BUSY,
        SUCCESS,
        FAILED,
        WARNING;

    }
}

