/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import java.net.URI;
import java.net.URL;
import javafx.application.HostServices;
import javafx.scene.control.TextInputDialog;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BrowserUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserUtil.class);
    private final Provider<HostServices> hostServicesProvider;

    @Inject
    public BrowserUtil(Provider<HostServices> hostServicesProvider) {
        this.hostServicesProvider = hostServicesProvider;
    }

    public boolean openUrlInBrowser(URL url) {
        return this.openUrlInBrowser(url.toExternalForm());
    }

    public boolean openUrlInBrowser(URI uri) {
        return this.openUrlInBrowser(uri.toASCIIString());
    }

    public boolean openUrlInBrowser(String url) {
        try {
            ((HostServices)this.hostServicesProvider.get()).showDocument(url);
        }
        catch (Throwable e1) {
            LOG.error("Error while trying to open external browser. Will try to work around it.", e1);
            try {
                String osName = System.getProperty("os.name");
                if (osName.startsWith("Mac OS")) {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    String[] browsers;
                    String browser = null;
                    for (String b : browsers = new String[]{"google-chrome", "firefox", "opera", "konqueror", "mozilla"}) {
                        if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                        Runtime.getRuntime().exec(new String[]{browser = b, url});
                    }
                    if (browser == null) {
                        TextInputDialog dialog = new TextInputDialog(url);
                        dialog.setTitle("Opening Browser failed");
                        dialog.setHeaderText("Opening Browser failed");
                        dialog.setContentText("As a workaround, you can copy the URL manually:");
                        dialog.showAndWait();
                    }
                }
            }
            catch (Exception e2) {
                LOG.error("Error while trying to open external browser with fallback method. Will throw uncaught exception now.", (Throwable)e2);
                throw new RuntimeException("Failed to open external browser (used 2 methods)", e2);
            }
        }
        return true;
    }
}

