/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;

public class DateTimeUtils {
    public static final DateTimeFormatter DATE_HOUR_MINUTES_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter DATE_HOUR_MINUTES_SECONDS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final int SECONDS = 0;
    public static final int MINUTES = 1;
    public static final int HOURS = 2;
    public static final int DAYS = 3;

    public static int[] getSecondsMinutesHoursDays(Duration duration) {
        int[] result = new int[4];
        long time = duration.getSeconds();
        result[0] = (int)(time % 60L);
        result[1] = (int)((time /= 60L) % 60L);
        result[2] = (int)((time /= 60L) % 24L);
        result[3] = (int)(time /= 24L);
        return result;
    }

    public static String prettyPrintDuration(Duration duration) {
        int[] parts = DateTimeUtils.getSecondsMinutesHoursDays(duration);
        LinkedList<CallSite> stringParts = new LinkedList<CallSite>();
        if (parts[3] > 0) {
            stringParts.add((CallSite)((Object)(parts[3] + " " + (parts[3] > 1 ? "days" : "day"))));
        }
        if (parts[2] > 0) {
            stringParts.add((CallSite)((Object)(parts[2] + " " + (parts[2] > 1 ? "hours" : "hour"))));
        }
        if (parts[1] > 0) {
            stringParts.add((CallSite)((Object)(parts[1] + " " + (parts[1] > 1 ? "minutes" : "minute"))));
        }
        if (parts[0] > 0) {
            stringParts.add((CallSite)((Object)(parts[0] + " " + (parts[0] > 1 ? "seconds" : "second"))));
        }
        if (stringParts.isEmpty()) {
            return "-";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((String)stringParts.removeLast());
        if (!stringParts.isEmpty()) {
            sb.insert(0, " and ");
            sb.insert(0, (String)stringParts.removeLast());
        }
        while (!stringParts.isEmpty()) {
            sb.insert(0, ", ");
            sb.insert(0, (String)stringParts.removeLast());
        }
        return sb.toString();
    }
}

