/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageSize;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ImageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ImageUtil.class);
    private final JFedGuiConfig config;
    private static final ImageSize[] FALLBACK_ORDER = new ImageSize[]{ImageSize.LARGE, ImageSize.MEDIUM, ImageSize.SMALL, ImageSize.X_SMALL};

    @Inject
    public ImageUtil(JFedGuiConfig config) {
        this.config = config;
    }

    @Nullable
    public Image getRspecNodeImage(FXRspecNode node, ImageSize imageSize) {
        return ImageUtil.getRspecNodeImage(this.config, node, imageSize);
    }

    @Nullable
    public static Image getRspecNodeImage(@Nonnull JFedGuiConfig config, @Nonnull FXRspecNode node, @Nonnull ImageSize imageSize) {
        ResourceClass resourceClass = config.getDefaultResourceClass();
        if (node.getResourceClassId() != null) {
            resourceClass = config.getResourceClass(node.getResourceClassId());
        }
        if (resourceClass == null) {
            LOG.error("ResourceClass should never be null here. node.getResourceClassId()=" + (String)(node.getResourceClassId() == null ? "null" : "\"" + node.getResourceClassId() + "\"") + " config.getDefaultResourceClass()=" + String.valueOf(config.getDefaultResourceClass()));
            return null;
        }
        return ImageUtil.getNodeDescriptionImage(resourceClass, imageSize);
    }

    @Nullable
    private static URL getNodeDescriptionImageURL(@Nonnull String imageId, @Nonnull ImageSize imageSize) {
        String urlString = String.format("/images/node_types/%d/%s.png", imageSize.getSize(), imageId);
        URL res = ImageUtil.class.getResource(urlString);
        return res;
    }

    @Nullable
    private static URL getNodeDescriptionImageURL(@Nonnull ResourceClass resourceClass, @Nonnull ImageSize imageSize) {
        if (resourceClass.getImageId() == null) {
            return null;
        }
        URL res = ImageUtil.getNodeDescriptionImageURL(resourceClass.getImageId(), imageSize);
        if (res == null && resourceClass.getImageUrl() != null) {
            try {
                return new URL(resourceClass.getImageUrl());
            }
            catch (MalformedURLException e) {
                LOG.error("Invalid URN in resourceClass " + (String)resourceClass.getId() + ": \"" + resourceClass.getImageUrl() + "\"", (Throwable)e);
                return null;
            }
        }
        return res;
    }

    @Nullable
    public static Image getNodeDescriptionImage(@Nonnull ResourceClass resourceClass, @Nonnull ImageSize imageSize) {
        assert (resourceClass != null);
        URL url = ImageUtil.getNodeDescriptionImageURL(resourceClass, imageSize);
        for (int i = 0; url == null && i < FALLBACK_ORDER.length; ++i) {
            url = ImageUtil.getNodeDescriptionImageURL(resourceClass, FALLBACK_ORDER[i]);
        }
        if (url != null) {
            return new Image(url.toExternalForm());
        }
        return null;
    }

    private static URL getTestbedImageURL(Server server, ImageSize imageSize) {
        if (server.getTestbed().getLogo() == null) {
            return null;
        }
        String urlString = String.format("/images/testbeds/%d/%s", imageSize.getSize(), server.getTestbed().getLogo());
        return ImageUtil.class.getResource(urlString);
    }

    public static Image getTestbedDescriptionImage(Server server, ImageSize imageSize) {
        if (server.getTestbed().getLogo() == null) {
            return null;
        }
        URL url = ImageUtil.getTestbedImageURL(server, imageSize);
        for (int i = 0; url == null && i < FALLBACK_ORDER.length; ++i) {
            url = ImageUtil.getTestbedImageURL(server, FALLBACK_ORDER[i]);
        }
        if (url != null) {
            return new Image(url.toExternalForm());
        }
        return null;
    }

    @Nonnull
    public static Image imageOrFallback(@Nullable Image nullableImage, @Nonnull ImageSize imageSize) {
        if (nullableImage != null && nullableImage.getPixelReader() != null) {
            assert (nullableImage.getPixelReader() != null);
            return nullableImage;
        }
        WritableImage im = new WritableImage(imageSize.getSize(), imageSize.getSize());
        assert (im.getPixelReader() != null);
        return im;
    }
}

