/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkInfoMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(LinkInfoMatcher.class);

    private LinkInfoMatcher() {
    }

    @Nonnull
    private static Resource.LinkInfoRules legacyLinkInfoRules(@Nullable Resource fromResource, @Nullable Resource toResource) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (fromResource != null) {
            resources.add(fromResource);
        }
        if (toResource != null) {
            resources.add(toResource);
        }
        return LinkInfoMatcher.legacyLinkInfoRules(resources);
    }

    private static Resource.LinkInfoRules legacyLinkInfoRules(@Nonnull List<Resource> resources) {
        if (resources.isEmpty()) {
            return new Resource.LinkInfoRules(Boolean.valueOf(false), Boolean.valueOf(false), Collections.emptyList(), null);
        }
        Resource firstResource = resources.get(0);
        assert (firstResource != null);
        boolean stitching = false;
        Integer firstServerId = firstResource.getServerId();
        for (Resource r : resources) {
            assert (r != null);
            if (r.getServerId() != null && firstServerId == null) {
                firstServerId = r.getServerId();
            }
            if (r.getServerId() == null || Objects.equals(r.getServerId(), firstServerId)) continue;
            stitching = true;
        }
        if (!stitching && firstResource.getAllowLinks() != null) {
            return new Resource.LinkInfoRules(firstResource.getAllowLinks(), Boolean.valueOf(true), firstResource.getAllowedLinkTypes(), firstResource.getDefaultLinkType());
        }
        if (stitching) {
            boolean use = false;
            Resource usedR = null;
            for (Resource r : resources) {
                if (r.getAllowStitchedLinks() != null) {
                    use = true;
                    if (usedR == null) {
                        usedR = r;
                    }
                }
                if (r.getAllowStitchedLinks() != Boolean.TRUE) continue;
                usedR = r;
            }
            if (use) {
                return new Resource.LinkInfoRules(Boolean.valueOf(usedR.getAllowStitchedLinks() == Boolean.TRUE), Boolean.valueOf(true), usedR.getAllowedLinkTypes(), usedR.getDefaultLinkType());
            }
        }
        if (!stitching) {
            return new Resource.LinkInfoRules(Boolean.valueOf(firstResource.getServer().getTestbed().getAllowLinks() == Boolean.TRUE), Boolean.valueOf(true), Collections.singletonList("lan"), null);
        }
        for (Resource r : resources) {
            if (!r.getServer().hasFlag(Server.Flag.featureStitching)) continue;
            return new Resource.LinkInfoRules(Boolean.valueOf(true), Boolean.valueOf(false), Collections.singletonList("lan"), "lan");
        }
        return new Resource.LinkInfoRules(Boolean.valueOf(false), Boolean.valueOf(false), Collections.singletonList("lan"), null);
    }

    @Nonnull
    public static Resource.LinkInfoRules findLinkInfoRules(@Nonnull JFedGuiConfig config, @Nonnull List<FXRspecNode> nodes) {
        if (nodes.isEmpty()) {
            return new Resource.LinkInfoRules(Boolean.valueOf(false), Boolean.valueOf(false), Collections.emptyList(), null);
        }
        if (nodes.size() == 1) {
            return new Resource.LinkInfoRules(Boolean.valueOf(false), Boolean.valueOf(false), Collections.emptyList(), null);
        }
        FXRspecNode firstNode = nodes.get(0);
        assert (firstNode != null);
        ArrayList<Resource> allResources = new ArrayList<Resource>(nodes.size());
        ArrayList<Resource> uniqueResources = new ArrayList<Resource>(nodes.size());
        for (FXRspecNode node : nodes) {
            ResourceClass nodeResourceClass = node.getResourceClassId() == null ? null : config.getResourceClass(node.getResourceClassId());
            Resource nodeResource = config.findBestResource(nodeResourceClass, (RspecNode)node, null);
            if (nodeResource == null) {
                LOG.warn("findLinkInfoRules Could not find Resource for node " + node.getUniqueId() + " -> fallback=refuse all links");
                return new Resource.LinkInfoRules(Boolean.valueOf(false), Boolean.valueOf(false), Collections.emptyList(), null);
            }
            if (uniqueResources.stream().map(PrimaryIdObject::getId).noneMatch(id -> Objects.equals(id, nodeResource.getId()))) {
                uniqueResources.add(nodeResource);
            }
            allResources.add(nodeResource);
        }
        Resource.LinkInfo bestMatch = null;
        int bestMatchLevel = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            FXRspecNode fromNode = nodes.get(i);
            Resource fromResource = (Resource)allResources.get(i);
            List fromLinkInfos = fromResource.getLinkInfoOrDefault();
            if (fromLinkInfos.isEmpty()) continue;
            for (int j = 0; j < nodes.size(); ++j) {
                if (j == i) continue;
                FXRspecNode toNode = nodes.get(j);
                Resource toResource = (Resource)allResources.get(j);
                for (Resource.LinkInfo linkInfo : fromLinkInfos) {
                    if (linkInfo.getFilter() != null) {
                        boolean match = false;
                        Resource.LinkInfoFilter filter = linkInfo.getFilter();
                        match |= filter.getMatchSameResource() == Boolean.TRUE && toResource != null && toResource.getId() != null && Objects.equals(fromResource.getId(), toResource.getId());
                        match |= filter.getMatchAnySameServer() == Boolean.TRUE && toResource != null && toResource.getServerId() != null && Objects.equals(fromResource.getServerId(), toResource.getServerId());
                        match |= filter.getMatchAnyInterServer() == Boolean.TRUE && toResource != null && toResource.getServerId() != null && !Objects.equals(fromResource.getServerId(), toResource.getServerId());
                        match |= filter.getMatchResourceId() != null && toResource != null && toResource.getId() != null && filter.getMatchResourceId().contains(toResource.getId());
                        match |= filter.getMatchServerId() != null && toResource != null && toResource.getServerId() != null && filter.getMatchServerId().contains(toResource.getServerId());
                        match |= filter.getMatchCategory() != null && toResource != null && toResource.getServerId() != null && toResource.getServer().getTestbed().getCategories().stream().map(TestbedCategory::getName).anyMatch(cat -> filter.getMatchCategory().contains(cat));
                        match |= filter.getMatchFederation() != null && toResource != null && toResource.getServerId() != null && toResource.getServer().getTestbed().getFederations().stream().map(PrimaryIdObject::getId).anyMatch(fed -> filter.getMatchFederation().contains(fed));
                        if (filter.getMaxNodeCount() != null && nodes.size() > filter.getMaxNodeCount()) {
                            match = false;
                        }
                        if (!match) continue;
                        int matchLevel = 0;
                        if (filter.getMatchResourceId() != null) {
                            matchLevel = 6;
                        }
                        if (filter.getMatchServerId() != null) {
                            matchLevel = 5;
                        }
                        if (filter.getMatchCategory() != null) {
                            matchLevel = 4;
                        }
                        if (filter.getMatchFederation() != null) {
                            matchLevel = 4;
                        }
                        if (filter.getMatchSameResource() == Boolean.TRUE) {
                            matchLevel = 3;
                        }
                        if (filter.getMatchAnySameServer() == Boolean.TRUE) {
                            matchLevel = 2;
                        }
                        if (filter.getMatchAnyInterServer() == Boolean.TRUE) {
                            matchLevel = 1;
                        }
                        if (bestMatch == null || bestMatchLevel < matchLevel) {
                            if (bestMatch != null && bestMatchLevel > 0) {
                                LOG.warn("Multiple LinkInfo matches for resource " + String.valueOf(fromResource.getId()) + " overwriting match with level " + bestMatchLevel + " for match with level " + matchLevel);
                            }
                            bestMatch = linkInfo;
                            bestMatchLevel = matchLevel;
                            continue;
                        }
                        LOG.warn("Multiple LinkInfo matches for resource " + String.valueOf(fromResource.getId()) + " keeping match with level " + bestMatchLevel + " because new match only has level " + matchLevel);
                        continue;
                    }
                    if (bestMatch != null) continue;
                    bestMatch = linkInfo;
                    bestMatchLevel = 0;
                }
            }
        }
        if (bestMatch != null) {
            return bestMatch.getRules();
        }
        return LinkInfoMatcher.legacyLinkInfoRules(allResources);
    }
}

