/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.EnvironmentParameterHandler;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.ExternalUserRequestHandler;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.FirstLoginParametersHandler;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.LoginValidationParameterHandler;
import be.iminds.ilabt.jfed.experimenter_gui.util.URIUtils;
import be.iminds.ilabt.jfed.lib.ApplicationParametersModule;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import java.awt.Desktop;
import java.awt.desktop.OpenURIEvent;
import java.awt.desktop.OpenURIHandler;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MacOpenURIHandler
implements OpenURIHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MacOpenURIHandler.class);
    private boolean firstUriReceived = true;
    private final FirstLoginParametersHandler firstLoginParametersHandler;
    private final LoginValidationParameterHandler loginValidationParameterHandler;
    private final ExternalUserRequestHandler externalUserRequestHandler;
    private final EnvironmentParameterHandler environmentParameterHandler;
    private final ApplicationParametersModule.ApplicationParameters applicationParameters;

    @Inject
    public MacOpenURIHandler(FirstLoginParametersHandler firstLoginParametersHandler, LoginValidationParameterHandler loginValidationParameterHandler, ExternalUserRequestHandler externalUserRequestHandler, EnvironmentParameterHandler environmentParameterHandler, ApplicationParametersModule.ApplicationParameters applicationParameters) {
        this.firstLoginParametersHandler = firstLoginParametersHandler;
        this.loginValidationParameterHandler = loginValidationParameterHandler;
        this.externalUserRequestHandler = externalUserRequestHandler;
        this.environmentParameterHandler = environmentParameterHandler;
        this.applicationParameters = applicationParameters;
        assert (OSDetector.findOS() == OSDetector.OS.MAC);
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().setOpenURIHandler(this);
        }
        LOG.debug("Registered Mac OpenURIHandler");
    }

    @Override
    public void openURI(OpenURIEvent openURIEvent) {
        Map<String, String> parameters = URIUtils.processJFedUri(openURIEvent.getURI().toString());
        this.applicationParameters.setParameters(parameters);
        if (this.firstUriReceived) {
            this.firstLoginParametersHandler.handleParameters();
            this.firstUriReceived = false;
        } else if (Objects.equals(Boolean.FALSE, this.loginValidationParameterHandler.handleParameters())) {
            LOG.info("Skipping processing of URI as it is for a different user");
            Platform.runLater(() -> new Alert(Alert.AlertType.WARNING, "jFed was launched via an URL. However, the URL specifies another user than the one currently logged in. Please quit this jFed session and try again.", new ButtonType[0]).showAndWait());
            return;
        }
        this.externalUserRequestHandler.handleParameters();
        this.environmentParameterHandler.handleParameters();
    }
}

