/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private final IntegerProperty nread = new SimpleIntegerProperty(0);
    private int size = 0;

    public ProgressMonitorInputStream(InputStream in) {
        super(in);
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0;
        }
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.nread.set(this.nread.get() + 1);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.nread.set(this.nread.get() + nr);
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.nread.set(this.nread.get() + nr);
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread.set(this.nread.get() + (int)nr);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread.set(this.size - this.in.available());
    }

    public int getNread() {
        return this.nread.get();
    }

    public IntegerProperty nreadProperty() {
        return this.nread;
    }

    public int getSize() {
        return this.size;
    }
}

