/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import be.iminds.ilabt.jfed.experimenter_gui.TriggeredMessageHandler;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.PreferencesDialogFactory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ssh_terminal_tool.ExternalRdpApp;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.lib.BestNodeLoginFinder;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RDPAppUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RDPAppUtil.class);
    private final JFedPreferences jFedPreferences;
    private final PreferencesDialogFactory preferencesDialogFactory;
    private final GeniUserProvider geniUserProvider;
    private final ProxyServiceUtil proxyServiceUtil;
    private final ExternalRdpApp externalRdpApp;
    private final TriggeredMessageHandler triggeredMessageHandler;

    @Inject
    public RDPAppUtil(JFedPreferences jFedPreferences, PreferencesDialogFactory preferencesDialogFactory, GeniUserProvider geniUserProvider, ProxyServiceUtil proxyServiceUtil, ExternalRdpApp externalRdpApp, TriggeredMessageHandler triggeredMessageHandler) {
        this.jFedPreferences = jFedPreferences;
        this.preferencesDialogFactory = preferencesDialogFactory;
        this.geniUserProvider = geniUserProvider;
        this.proxyServiceUtil = proxyServiceUtil;
        this.externalRdpApp = externalRdpApp;
        this.triggeredMessageHandler = triggeredMessageHandler;
    }

    public void launchRdpAppForcedLocalUser(FXRspecNode rspecNode, ManifestRspecSource manifestRspecSource) {
        String username = this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName();
        this.launchRdpApp(rspecNode, manifestRspecSource, username);
    }

    public void launchRdpAppForcedLocalUser(FXRspecNode rspecNode, Slice slice) {
        String username = this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName();
        this.launchRdpApp(rspecNode, slice, username);
    }

    public void launchRdpApp(FXRspecNode rspecNode, Slice slice) {
        this.launchRdpApp(rspecNode, slice, null);
    }

    public void launchRdpApp(@Nonnull FXRspecNode rspecNode, @Nullable Slice slice, @Nullable String overrideUserName) {
        if (slice == null) {
            LOG.warn("Could not open RDP application: manifestRspecSource=null");
            JFDialogs.create().message("There is currently insufficient information available to start the Remote Desktop application.").showError();
        } else {
            this.launchRdpApp(rspecNode, slice.getManifestRspec(), overrideUserName);
        }
    }

    public void launchRdpApp(FXRspecNode rspecNode, ManifestRspecSource manifestRspecSource) {
        this.launchRdpApp(rspecNode, manifestRspecSource, null);
    }

    public boolean hasRdpService(@Nonnull FXRspecNode rspecNode, @Nullable Slice slice) {
        if (slice == null || slice.getManifestRspec() == null || slice.getManifestRspec().getStringRspec() == null) {
            return false;
        }
        List basicNodeInfos = slice.getManifestRspec().getStringRspec().getBasicNodeInfo();
        if (basicNodeInfos == null) {
            return false;
        }
        String nodeUniqueId = rspecNode == null ? null : rspecNode.getUniqueId();
        BasicStringRspec.BasicNodeInfo basicNodeInfo = null;
        for (BasicStringRspec.BasicNodeInfo cur : basicNodeInfos) {
            if (!Objects.equals(cur.getUniqueId(), nodeUniqueId)) continue;
            basicNodeInfo = cur;
        }
        if (basicNodeInfo == null) {
            return false;
        }
        List rdpServiceList = slice.getManifestRspec().getStringRspec().findNodeRdpInfoByUniqueId(nodeUniqueId);
        return !rdpServiceList.isEmpty();
    }

    public void launchRdpApp(@Nonnull FXRspecNode rspecNode, @Nullable ManifestRspecSource manifestRspecSource, @Nullable String overrideUsername) {
        if (manifestRspecSource == null) {
            LOG.warn("launchRdpApp: Could not open SSH terminal: manifestRspecSource=null");
            JFDialogs.create().message("There is currently insufficient information available to login.").showError();
            return;
        }
        LOG.warn("launchRdpApp called with rspecNode " + rspecNode.getUniqueId() + " overrideUsername=" + overrideUsername);
        BestNodeLoginFinder bestNodeLoginFinder = new BestNodeLoginFinder((BasicStringRspec)manifestRspecSource.getStringRspec(), overrideUsername, this.geniUserProvider.getLoggedInGeniUser(), new BestNodeLoginFinder.Feedback(){

            public void info(String s) {
                LOG.info("launchRdpApp: " + s);
            }

            public void error(String s) {
                LOG.error("launchRdpApp: " + s);
            }

            public void debug(String s) {
                LOG.debug("launchRdpApp: " + s);
            }
        });
        Optional<BasicStringRspec.RdpService> best = Optional.ofNullable(bestNodeLoginFinder.findBestRdp(rspecNode.getUniqueId()));
        if (best.isPresent()) {
            LOG.debug("launchRdpApp: found login service for user " + best.get().getUsername());
            BasicStringRspec.RdpService bestRdpService = best.get();
            if (bestRdpService.getSshProxy() != null && bestRdpService.getSshProxy().getSshKeyInfo() == null) {
                LOG.warn("Found proxy info with empty SshKeyInfo. Replacing with logged-in user SshKeyInfo");
                JFedHLPreferences guiPrefs = this.jFedPreferences instanceof JFedHLPreferences ? (JFedHLPreferences)this.jFedPreferences : null;
                PuTTYFilesKeyInfo overriddenUserSshKey = guiPrefs == null ? null : guiPrefs.getCustomSshKeyInfo();
                GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
                JFedConnection.SshProxyInfo newSshProxyInfo = new JFedConnection.SshProxyInfo(bestRdpService.getSshProxy(), (SshKeyInfo)(overriddenUserSshKey != null ? overriddenUserSshKey : SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser)));
                bestRdpService = new BasicStringRspec.RdpService(bestRdpService.getHostname(), bestRdpService.getPort(), bestRdpService.getUsername(), bestRdpService.getPassword(), newSshProxyInfo);
            }
            this.launchRdpApp(bestRdpService, overrideUsername);
            return;
        }
        LOG.warn("launchRdpApp: There are no rdpServices available for {}", (Object)rspecNode.getClientId());
        JFDialogs.create().message("The selected node doesn't provide any information to perform an interactive login.").masthead("Could not open SSH terminal").title("Could not open SSH terminal").showException((Throwable)new RuntimeException("node id=\"" + rspecNode.getUniqueId() + "\" " + manifestRspecSource.getStringRspec().getXmlString()));
    }

    public void launchRdpApp(BasicStringRspec.RdpService rdpService) {
        this.launchRdpApp(rdpService, null);
    }

    private void launchRdpApp(@Nonnull BasicStringRspec.RdpService rdpService, @Nullable String overrideUsername) {
        Preconditions.checkNotNull((Object)rdpService);
        try {
            this.triggeredMessageHandler.onEvent(TriggeredMessage.GuiTrigger.SSH_TERMINAL_START);
        }
        catch (Exception e) {
            LOG.error("Error showing Triggered Message (will be ignored)", (Throwable)e);
        }
        if (!this.externalRdpApp.isConfigured()) {
            LOG.warn("ExternalSRdpApp is not configured. Showing warning dialog.");
            JFDialogs.create().message("jFed must be configured with the location of the terminal application and a valid Private Key.").showWarning();
            this.preferencesDialogFactory.showDialog();
        }
        if (!this.externalRdpApp.isConfigured()) {
            JFDialogs.create().message("jFed was not properly configured. Please configure jFed first, and try again.").showError();
            return;
        }
        this.externalRdpApp.launch(overrideUsername != null ? overrideUsername : rdpService.getUsername(), rdpService.getHostname(), rdpService.getPort(), rdpService.getPassword(), (JFedConnection.ProxyInfo)rdpService.getSshProxy());
    }
}

