/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class RemovingInputStream
extends FilterInputStream {
    int[] buf = null;
    int matchedIndex = 0;
    int unbufferIndex = 0;
    int replacedIndex = 0;
    private final byte[] patternStart;
    private final byte patternEnd;
    private final int maxRemoveLen;
    private State state = State.NOT_MATCHED;

    public RemovingInputStream(InputStream in, String patternStart, char patternEnd, int maxRemoveLen) {
        this(in, patternStart.getBytes(StandardCharsets.UTF_8), ("" + patternEnd).getBytes(StandardCharsets.UTF_8)[0], maxRemoveLen);
        assert (("" + patternEnd).getBytes(StandardCharsets.UTF_8).length == 1);
    }

    public RemovingInputStream(InputStream in, byte[] patternStart, byte patternEnd, int maxRemoveLen) {
        super(in);
        assert (patternStart != null);
        assert (patternStart.length > 0) : "pattern length (" + patternStart.length + ") should be > 0";
        this.patternStart = patternStart;
        this.patternEnd = patternEnd;
        this.maxRemoveLen = maxRemoveLen;
        this.buf = new int[maxRemoveLen + 1];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        switch (this.state.ordinal()) {
            case 0: {
                int next = super.read();
                if (this.patternStart[0] == next) {
                    this.buf = new int[this.maxRemoveLen + 1];
                    this.matchedIndex = 0;
                    this.buf[this.matchedIndex++] = next;
                    if (this.patternStart.length == 1) {
                        this.state = State.REMOVING;
                        this.replacedIndex = 0;
                    } else {
                        this.state = State.MATCHING;
                    }
                    return this.read();
                }
                return next;
            }
            case 1: {
                int next = super.read();
                while (next != -1 && this.state == State.MATCHING) {
                    if (this.patternStart[this.matchedIndex] == next) {
                        this.buf[this.matchedIndex++] = next;
                        if (this.matchedIndex == this.patternStart.length) {
                            this.state = State.REMOVING;
                            continue;
                        }
                        next = super.read();
                        continue;
                    }
                    this.buf[this.matchedIndex++] = next;
                    this.state = State.UNBUFFER;
                    this.unbufferIndex = 0;
                }
                return this.read();
            }
            case 2: {
                int next = super.read();
                while (next != -1 && this.state == State.REMOVING) {
                    this.buf[this.matchedIndex++] = next;
                    if (next == this.patternEnd) {
                        this.state = State.NOT_MATCHED;
                        continue;
                    }
                    if (this.matchedIndex >= this.maxRemoveLen) {
                        this.state = State.UNBUFFER;
                        this.unbufferIndex = 0;
                        continue;
                    }
                    next = super.read();
                }
                return this.read();
            }
            case 3: {
                int next = this.buf[this.unbufferIndex++];
                if (this.unbufferIndex == this.matchedIndex) {
                    this.state = State.NOT_MATCHED;
                    this.matchedIndex = 0;
                }
                return next;
            }
        }
        throw new IllegalStateException("no such state " + String.valueOf((Object)this.state));
    }

    public String toString() {
        return this.state.name() + " " + this.matchedIndex + " " + this.replacedIndex + " " + this.unbufferIndex;
    }

    private static enum State {
        NOT_MATCHED,
        MATCHING,
        REMOVING,
        UNBUFFER;

    }
}

