/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import be.iminds.ilabt.jfed.experimenter_gui.TriggeredMessageHandler;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.PreferencesDialogFactory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ssh_terminal_tool.ExternalSshTerminal;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.lib.BestNodeLoginFinder;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SSHTerminalUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SSHTerminalUtil.class);
    private final JFedPreferences jFedPreferences;
    private final ExternalSshTerminal externalSshTerminal;
    private final PreferencesDialogFactory preferencesDialogFactory;
    private final GeniUserProvider geniUserProvider;
    private final ProxyServiceUtil proxyServiceUtil;
    private final TriggeredMessageHandler triggeredMessageHandler;

    @Inject
    public SSHTerminalUtil(JFedPreferences jFedPreferences, ExternalSshTerminal externalSshTerminal, PreferencesDialogFactory preferencesDialogFactory, GeniUserProvider geniUserProvider, ProxyServiceUtil proxyServiceUtil, TriggeredMessageHandler triggeredMessageHandler) {
        this.jFedPreferences = jFedPreferences;
        this.externalSshTerminal = externalSshTerminal;
        this.preferencesDialogFactory = preferencesDialogFactory;
        this.geniUserProvider = geniUserProvider;
        this.proxyServiceUtil = proxyServiceUtil;
        this.triggeredMessageHandler = triggeredMessageHandler;
    }

    public void launchSSHTerminalForcedLocalUser(FXRspecNode rspecNode, ManifestRspecSource manifestRspecSource) {
        String username = this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName();
        this.launchSSHTerminal(rspecNode, manifestRspecSource, username);
    }

    public void launchSSHTerminalForcedLocalUser(FXRspecNode rspecNode, Slice slice) {
        String username = this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName();
        this.launchSSHTerminal(rspecNode, slice, username);
    }

    public void launchSSHTerminal(FXRspecNode rspecNode, Slice slice) {
        this.launchSSHTerminal(rspecNode, slice, null);
    }

    public void launchSSHTerminal(@Nonnull FXRspecNode rspecNode, @Nullable Slice slice, @Nullable String overrideUserName) {
        if (slice == null) {
            LOG.warn("Could not open SSH terminal: manifestRspecSource=null");
            JFDialogs.create().message("There is currently insufficient information available to login.").showError();
        } else {
            this.launchSSHTerminal(rspecNode, slice.getManifestRspec(), overrideUserName);
        }
    }

    public void launchSSHTerminal(FXRspecNode rspecNode, ManifestRspecSource manifestRspecSource) {
        this.launchSSHTerminal(rspecNode, manifestRspecSource, null);
    }

    @Nonnull
    public List<BasicStringRspec.LoginService> findAllLoginService(FXRspecNode rspecNode, @Nonnull Slice slice) {
        return this.findAllLoginService(rspecNode, slice.getManifestRspec());
    }

    @Nonnull
    public List<BasicStringRspec.LoginService> findAllLoginService(FXRspecNode rspecNode, @Nullable ManifestRspecSource manifestRspecSource) {
        if (manifestRspecSource == null) {
            return Collections.emptyList();
        }
        StringRspec basicStringRspec = manifestRspecSource.getStringRspec();
        if (basicStringRspec == null) {
            return Collections.emptyList();
        }
        List basicNodeInfos = basicStringRspec.getBasicNodeInfo();
        if (basicNodeInfos == null) {
            return Collections.emptyList();
        }
        return basicStringRspec.findNodeLoginInfoByUniqueId(rspecNode.getUniqueId());
    }

    @Nonnull
    public Optional<BasicStringRspec.LoginService> findBestLoginService(@Nonnull FXRspecNode rspecNode, @Nonnull Slice slice) {
        return this.findBestLoginService(rspecNode, slice.getManifestRspec(), null);
    }

    @Nonnull
    public Optional<BasicStringRspec.LoginService> findBestLoginService(@Nonnull FXRspecNode rspecNode, @Nullable ManifestRspecSource manifestRspecSource, @Nullable String overrideUsername) {
        if (manifestRspecSource == null) {
            return Optional.empty();
        }
        StringRspec basicStringRspec = manifestRspecSource.getStringRspec();
        if (basicStringRspec == null) {
            return Optional.empty();
        }
        BestNodeLoginFinder bestNodeLoginFinder = new BestNodeLoginFinder((BasicStringRspec)basicStringRspec, overrideUsername, this.geniUserProvider.getLoggedInGeniUser(), new BestNodeLoginFinder.Feedback(){

            public void info(String s) {
                LOG.info("launchSSHTerminal: " + s);
            }

            public void error(String s) {
                LOG.error("launchSSHTerminal: " + s);
            }

            public void debug(String s) {
                LOG.debug("launchSSHTerminal: " + s);
            }
        });
        Optional<BasicStringRspec.LoginService> best = Optional.ofNullable(bestNodeLoginFinder.findBestLogin(rspecNode.getUniqueId()));
        if (best.isPresent()) {
            LOG.debug("launchSSHTerminal: found login service for user " + best.get().getUsername());
            BasicStringRspec.LoginService bestLoginService = best.get();
            if (bestLoginService.getSshProxy() != null && bestLoginService.getSshProxy().getSshKeyInfo() == null) {
                LOG.warn("Found proxy info with empty SshKeyInfo. Replacing with logged-in user SshKeyInfo");
                JFedHLPreferences guiPrefs = this.jFedPreferences instanceof JFedHLPreferences ? (JFedHLPreferences)this.jFedPreferences : null;
                PuTTYFilesKeyInfo overriddenUserSshKey = guiPrefs == null ? null : guiPrefs.getCustomSshKeyInfo();
                GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
                JFedConnection.SshProxyInfo newSshProxyInfo = new JFedConnection.SshProxyInfo(bestLoginService.getSshProxy(), (SshKeyInfo)(overriddenUserSshKey != null ? overriddenUserSshKey : SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser)));
                bestLoginService = new BasicStringRspec.LoginService(bestLoginService.getAuthentication(), bestLoginService.getHostname(), bestLoginService.getPort(), bestLoginService.getUsername(), newSshProxyInfo);
            }
            return Optional.of(bestLoginService);
        }
        return Optional.empty();
    }

    public void launchSSHTerminal(@Nonnull FXRspecNode rspecNode, @Nullable ManifestRspecSource manifestRspecSource, @Nullable String overrideUsername) {
        if (manifestRspecSource == null) {
            LOG.warn("launchSSHTerminal: Could not open SSH terminal: manifestRspecSource=null");
            JFDialogs.create().message("There is currently insufficient information available to login.").showError();
            return;
        }
        LOG.warn("launchSSHTerminal called with rspecNode " + rspecNode.getUniqueId() + " overrideUsername=" + overrideUsername);
        Optional<BasicStringRspec.LoginService> best = this.findBestLoginService(rspecNode, manifestRspecSource, overrideUsername);
        if (best.isPresent()) {
            LOG.debug("launchSSHTerminal: found login service for user " + best.get().getUsername());
            BasicStringRspec.LoginService bestLoginService = best.get();
            this.launchSSHTerminal(bestLoginService, overrideUsername);
            return;
        }
        LOG.warn("launchSSHTerminal: There are no loginServices available for {}", (Object)rspecNode.getClientId());
        JFDialogs.create().message("The selected node doesn't provide any information to perform an interactive login.").masthead("Could not open SSH terminal").title("Could not open SSH terminal").showException((Throwable)new RuntimeException("node id=\"" + rspecNode.getUniqueId() + "\" " + manifestRspecSource.getStringRspec().getXmlString()));
    }

    public void launchSSHTerminal(BasicStringRspec.LoginService loginService) {
        this.launchSSHTerminal(loginService, null);
    }

    public void launchSSHTerminal(@Nonnull BasicStringRspec.LoginService loginService, @Nullable String overrideUsername) {
        Preconditions.checkNotNull((Object)loginService);
        try {
            this.triggeredMessageHandler.onEvent(TriggeredMessage.GuiTrigger.SSH_TERMINAL_START);
        }
        catch (Exception e) {
            LOG.error("Error showing Triggered Message (will be ignored)", (Throwable)e);
        }
        if (!this.externalSshTerminal.isConfigured()) {
            LOG.warn("ExternalSsshTerminal is not configured. Showing warning dialog.");
            JFDialogs.create().message("jFed must be configured with the location of the terminal application and a valid Private Key.").showWarning();
            this.preferencesDialogFactory.showDialog();
        }
        if (!this.externalSshTerminal.isConfigured()) {
            JFDialogs.create().message("jFed was not properly configured. Please configure jFed first, and try again.").showError();
            return;
        }
        this.externalSshTerminal.launch(overrideUsername != null ? overrideUsername : loginService.getUsername(), loginService.getHostname(), loginService.getPort(), (JFedConnection.ProxyInfo)loginService.getSshProxy());
    }
}

