/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.TestbedSiteInfo;
import be.iminds.ilabt.jfed.experimenter_gui.util.DateTimeUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javafx.util.StringConverter;

public class StringConverters {
    public static final StringConverter<DiskImage> DISK_IMAGE_STRING_CONVERTER = new StringConverter<DiskImage>(){

        public String toString(DiskImage diskImage) {
            if (diskImage == null) {
                return null;
            }
            if (diskImage.getDescription() != null) {
                return diskImage.getDescription();
            }
            if (diskImage.getOs() != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(diskImage.getOs());
                if (diskImage.getVersion() != null) {
                    sb.append(" v");
                    sb.append(diskImage.getVersion());
                }
                return sb.toString();
            }
            if (diskImage.getName() != null) {
                return diskImage.getName();
            }
            return String.format("<%s>", diskImage.getUrl());
        }

        public DiskImage fromString(String s) {
            return null;
        }
    };
    public static final StringConverter<AggregateManagerWrapper.ImageInfo> IMAGEINFO_STRING_CONVERTER = new StringConverter<AggregateManagerWrapper.ImageInfo>(){

        public String toString(AggregateManagerWrapper.ImageInfo imageInfo) {
            if (imageInfo == null) {
                return null;
            }
            if (imageInfo.getUrn() != null) {
                GeniUrn geniUrn = GeniUrn.parse((String)imageInfo.getUrn());
                if (geniUrn != null) {
                    return geniUrn.getEncodedResourceName();
                }
                return imageInfo.getUrn();
            }
            return imageInfo.getUrl();
        }

        public AggregateManagerWrapper.ImageInfo fromString(String s) {
            return null;
        }
    };
    public static final StringConverter<Resource> RESOURCE_STRING_CONVERTER = new StringConverter<Resource>(){

        public String toString(Resource resource) {
            if (resource == null || resource.getServer() == null) {
                return null;
            }
            return resource.getServer().getName();
        }

        public Resource fromString(String s) {
            throw new UnsupportedOperationException();
        }
    };
    public static final StringConverter<Server> SERVER_STRING_CONVERTER = new StringConverter<Server>(){

        public String toString(Server server) {
            if (server == null) {
                return null;
            }
            return server.getName();
        }

        public Server fromString(String s) {
            throw new UnsupportedOperationException();
        }
    };
    public static final StringConverter<TestbedSiteInfo> TESTBEDSITEINFO_STRING_CONVERTER = new StringConverter<TestbedSiteInfo>(){

        public String toString(TestbedSiteInfo info) {
            if (info == null) {
                return null;
            }
            return info.getHrn();
        }

        public TestbedSiteInfo fromString(String s) {
            throw new UnsupportedOperationException();
        }
    };
    public static final StringConverter<FXRspecNode> ADV_RSPECNODE_CONVERTER = new StringConverter<FXRspecNode>(){

        public String toString(FXRspecNode node) {
            if (node.getComponentName() != null) {
                return node.getComponentName();
            }
            if (node.getComponentId() != null) {
                return node.getComponentId().getEncodedResourceName();
            }
            return node.getClientId();
        }

        public FXRspecNode fromString(String string) {
            throw new UnsupportedOperationException();
        }
    };
    public static final StringConverter<JFedGuiConfig.ComponentInfo> COMPONENT_INFO_CONVERTER = new StringConverter<JFedGuiConfig.ComponentInfo>(){

        public String toString(JFedGuiConfig.ComponentInfo node) {
            if (node == null) {
                return null;
            }
            if (node.getName() != null) {
                return node.getName();
            }
            if (node.getUrn() != null) {
                return node.getUrn().getEncodedResourceName();
            }
            return null;
        }

        public JFedGuiConfig.ComponentInfo fromString(String string) {
            throw new UnsupportedOperationException();
        }
    };
    public static final StringConverter<GeniUrn> GENI_URN_CONVERTER = new StringConverter<GeniUrn>(){

        public String toString(GeniUrn object) {
            return object.getEncodedResourceName();
        }

        public GeniUrn fromString(String string) {
            throw new UnsupportedOperationException();
        }
    };
    public static final StringConverter<Channel> CHANNEL_CONVERTER = new StringConverter<Channel>(){

        public String toString(Channel channel) {
            if (channel == null) {
                return null;
            }
            if (channel.getFrequency() == null) {
                return channel.getComponentName();
            }
            return String.format("%s (%s)", channel.getComponentName(), channel.getFrequency());
        }

        public Channel fromString(String string) {
            throw new UnsupportedOperationException();
        }
    };
    public static final StringConverter<Instant> INSTANT_STRING_CONVERTER = new StringConverter<Instant>(){

        public String toString(Instant date) {
            if (date != null) {
                return DateTimeUtils.DATE_HOUR_MINUTES_SECONDS_FORMATTER.format(LocalDateTime.ofInstant(date, ZoneId.systemDefault()));
            }
            return null;
        }

        public Instant fromString(String s) {
            return ZonedDateTime.parse(s, DateTimeUtils.DATE_HOUR_MINUTES_SECONDS_FORMATTER).toInstant();
        }
    };
    public static final StringConverter<HardwareType> HARDWARE_TYPE_CONVERTER = new StringConverter<HardwareType>(){

        public String toString(HardwareType hardwareType) {
            return hardwareType.getName();
        }

        public HardwareType fromString(String string) {
            throw new UnsupportedOperationException();
        }
    };

    private StringConverters() {
    }
}

