/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIUtils {
    private static final Logger LOG = LoggerFactory.getLogger(URIUtils.class);
    public static final String JFED_URI_SCHEME = "jfed";
    private static final String UTF_8 = "UTF-8";

    private URIUtils() {
    }

    @Nullable
    public static Map<String, String> processJFedUri(@Nonnull String uriString) {
        if (uriString.endsWith("/")) {
            LOG.debug("Removing trailing slash from URI");
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        try {
            URI uri = new URI(uriString);
            if (JFED_URI_SCHEME.equalsIgnoreCase(uri.getScheme())) {
                String[] nameValuePairs;
                String schemeSpecificPart = uri.getSchemeSpecificPart();
                if (schemeSpecificPart.startsWith("//")) {
                    schemeSpecificPart = schemeSpecificPart.substring(2);
                }
                LOG.debug("Found a jFed-URI with the following contents: {}", (Object)schemeSpecificPart);
                HashMap<String, String> namedParameters = new HashMap<String, String>();
                for (String nameValuePair : nameValuePairs = schemeSpecificPart.split("&")) {
                    int splitIndex = nameValuePair.indexOf("=");
                    if (splitIndex >= 0) {
                        String name = nameValuePair.substring(0, splitIndex);
                        String value = nameValuePair.substring(splitIndex + 1);
                        if (namedParameters.containsKey(name)) {
                            LOG.warn("URI '{}' was already registered with value '{}'. Ignoring new value '{}'", new Object[]{name, namedParameters.get(name), value});
                            continue;
                        }
                        namedParameters.put(name, value);
                        continue;
                    }
                    LOG.warn("Could not parse parameter '{}'. Skipping.", (Object)nameValuePair);
                }
                return namedParameters;
            }
            LOG.warn("Encountered an URI, but with an unexpected scheme '{}'. Ignoring", (Object)uri.getScheme());
            return null;
        }
        catch (URISyntaxException ex) {
            LOG.error("Received startup parameter '{}', but could not process it.", (Object)uriString, (Object)ex);
            return null;
        }
    }
}

