/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util.force;

import be.iminds.ilabt.jfed.experimenter_gui.util.force.ForceItem;
import be.iminds.ilabt.jfed.experimenter_gui.util.force.ForceSimulator;
import be.iminds.ilabt.jfed.experimenter_gui.util.force.Integrator;
import java.util.Iterator;

public class EulerIntegrator
implements Integrator {
    @Override
    public void integrate(ForceSimulator sim, long timestep) {
        float speedLimit = sim.getSpeedLimit();
        Iterator iter = sim.getItems();
        while (iter.hasNext()) {
            ForceItem item = (ForceItem)iter.next();
            item.location[0] = item.location[0] + (float)timestep * item.velocity[0];
            item.location[1] = item.location[1] + (float)timestep * item.velocity[1];
            float coeff = (float)timestep / item.mass;
            item.velocity[0] = item.velocity[0] + coeff * item.force[0];
            item.velocity[1] = item.velocity[1] + coeff * item.force[1];
            float vx = item.velocity[0];
            float vy = item.velocity[1];
            float v = (float)Math.sqrt(vx * vx + vy * vy);
            if (!(v > speedLimit)) continue;
            item.velocity[0] = speedLimit * vx / v;
            item.velocity[1] = speedLimit * vy / v;
        }
    }
}

