/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class CustomChoiceDialog<T>
extends Dialog<T> {
    private final GridPane grid;
    private final Label label;
    private final ComboBox<T> comboBox;
    private final T defaultChoice;
    private final BooleanProperty comboboxBelowText = new SimpleBooleanProperty(false);

    public CustomChoiceDialog() {
        this(null, (Object[])null);
    }

    public CustomChoiceDialog(T defaultChoice, T ... choices) {
        this(defaultChoice, choices == null ? Collections.emptyList() : Arrays.asList(choices));
    }

    public CustomChoiceDialog(T defaultChoice, Collection<T> choices) {
        DialogPane dialogPane = this.getDialogPane();
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setVgap(10.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        this.label = CustomChoiceDialog.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.comboboxBelowText.addListener(o -> this.updateGrid());
        this.setTitle("Confirm");
        dialogPane.setHeaderText("Confirm");
        dialogPane.getStyleClass().add((Object)"choice-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        double MIN_WIDTH = 150.0;
        this.comboBox = new ComboBox();
        this.comboBox.setMinWidth(150.0);
        if (choices != null) {
            this.comboBox.getItems().addAll(choices);
        }
        this.comboBox.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow(this.comboBox, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth(this.comboBox, (Boolean)true);
        Object object = this.defaultChoice = this.comboBox.getItems().contains(defaultChoice) ? defaultChoice : null;
        if (defaultChoice == null) {
            this.comboBox.getSelectionModel().selectFirst();
        } else {
            this.comboBox.getSelectionModel().select(defaultChoice);
        }
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? this.getSelectedItem() : null;
        });
    }

    public void setStringConverter(StringConverter<T> stringConverter) {
        this.comboBox.setConverter(stringConverter);
    }

    public StringConverter<T> getStringConverter() {
        return this.comboBox.getConverter();
    }

    public boolean getComboboxBelowText() {
        return this.comboboxBelowText.get();
    }

    public BooleanProperty comboboxBelowTextProperty() {
        return this.comboboxBelowText;
    }

    public void setComboboxBelowText(boolean comboboxBelowText) {
        this.comboboxBelowText.set(comboboxBelowText);
    }

    private static Label createContentLabel(String text) {
        Label label = new Label(text);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.getStyleClass().add((Object)"content");
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public final T getSelectedItem() {
        return (T)this.comboBox.getSelectionModel().getSelectedItem();
    }

    public final ReadOnlyObjectProperty<T> selectedItemProperty() {
        return this.comboBox.getSelectionModel().selectedItemProperty();
    }

    public final void setSelectedItem(T item) {
        this.comboBox.getSelectionModel().select(item);
    }

    public final ObservableList<T> getItems() {
        return this.comboBox.getItems();
    }

    public final T getDefaultChoice() {
        return this.defaultChoice;
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add((Node)this.label, 0, 0);
        this.grid.add(this.comboBox, this.comboboxBelowText.get() ? 0 : 1, this.comboboxBelowText.get() ? 1 : 0);
        this.getDialogPane().setContent((Node)this.grid);
        Platform.runLater(() -> this.comboBox.requestFocus());
    }
}

