/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util.ui;

import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.collections.ObservableList;

public class OneTrueInListBinding<S>
extends BooleanBinding {
    private final ObservableList<S> list;
    private final Function<S, BooleanBinding> conversionFunction;

    public OneTrueInListBinding(ObservableList<S> list, Function<S, BooleanBinding> conversionFunction) {
        this.list = list;
        this.conversionFunction = conversionFunction;
        list.addListener(c -> {
            while (c.next()) {
                for (Object item : c.getAddedSubList()) {
                    this.bind(new Observable[]{(Observable)conversionFunction.apply(item)});
                }
                for (Object item : c.getRemoved()) {
                    this.unbind(new Observable[]{(Observable)conversionFunction.apply(item)});
                }
            }
        });
        list.forEach(item -> this.bind(new Observable[]{(Observable)conversionFunction.apply(item)}));
    }

    protected boolean computeValue() {
        for (Object item : this.list) {
            if (!this.conversionFunction.apply(item).get()) continue;
            return true;
        }
        return false;
    }
}

