/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyledCheckBoxListCell<T>
extends ListCell<T> {
    private static final Logger LOG = LoggerFactory.getLogger(StyledCheckBoxListCell.class);
    private final CheckBox checkBox;
    private ObservableValue<Boolean> booleanProperty;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");
    private ObjectProperty<StyleProvider<T>> styleProvider = new SimpleObjectProperty((Object)this, "styleProvider");
    private ObjectProperty<Callback<T, ObservableValue<Boolean>>> selectedStateCallback = new SimpleObjectProperty((Object)this, "selectedStateCallback");
    private List<String> baseStyleClasses;
    private static final StringConverter<?> defaultStringConverter = new StringConverter(){

        public String toString(Object t) {
            return t == null ? null : t.toString();
        }

        public Object fromString(String string) {
            return string;
        }
    };

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(Callback<T, ObservableValue<Boolean>> getSelectedProperty, StyleProvider<T> styleProvider) {
        return StyledCheckBoxListCell.forListView(getSelectedProperty, defaultStringConverter, styleProvider);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(Callback<T, ObservableValue<Boolean>> getSelectedProperty, StringConverter<T> converter, StyleProvider<T> styleProvider) {
        return list -> new StyledCheckBoxListCell(getSelectedProperty, converter, styleProvider);
    }

    public StyledCheckBoxListCell() {
        this(null, null);
    }

    public StyledCheckBoxListCell(Callback<T, ObservableValue<Boolean>> getSelectedProperty, StyleProvider<T> styleProvider) {
        this(getSelectedProperty, defaultStringConverter, styleProvider);
    }

    public StyledCheckBoxListCell(Callback<T, ObservableValue<Boolean>> getSelectedProperty, StringConverter<T> converter, StyleProvider<T> styleProvider) {
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("StyledCheckBoxListCell.css").toExternalForm());
        this.getStyleClass().add((Object)"check-box-list-cell");
        this.baseStyleClasses = Collections.unmodifiableList(new ArrayList(this.getStyleClass()));
        this.setSelectedStateCallback(getSelectedProperty);
        this.setConverter(converter);
        this.setStyleProvider(styleProvider);
        this.checkBox = new CheckBox();
        this.setAlignment(Pos.CENTER_LEFT);
        this.setContentDisplay(ContentDisplay.LEFT);
        this.setGraphic(null);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public StyleProvider getStyleProvider() {
        return (StyleProvider)this.styleProvider.get();
    }

    public ObjectProperty<StyleProvider<T>> styleProviderProperty() {
        return this.styleProvider;
    }

    public void setStyleProvider(StyleProvider styleProvider) {
        this.styleProvider.set((Object)styleProvider);
    }

    public final ObjectProperty<Callback<T, ObservableValue<Boolean>>> selectedStateCallbackProperty() {
        return this.selectedStateCallback;
    }

    public final void setSelectedStateCallback(Callback<T, ObservableValue<Boolean>> value) {
        this.selectedStateCallbackProperty().set(value);
    }

    public final Callback<T, ObservableValue<Boolean>> getSelectedStateCallback() {
        return (Callback)this.selectedStateCallbackProperty().get();
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (!empty) {
            StringConverter<T> c = this.getConverter();
            Callback<T, ObservableValue<Boolean>> callback = this.getSelectedStateCallback();
            if (callback == null) {
                throw new NullPointerException("The StyledCheckBoxListCell selectedStateCallbackProperty can not be null");
            }
            this.setGraphic((Node)this.checkBox);
            this.setText(c != null ? c.toString(item) : (item == null ? "" : item.toString()));
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((Property)((BooleanProperty)this.booleanProperty));
            }
            ArrayList<String> styleClasses = new ArrayList<String>(this.baseStyleClasses.size() + 1);
            styleClasses.addAll(this.baseStyleClasses);
            if (this.styleProvider.isNotNull().get()) {
                styleClasses.addAll(((StyleProvider)this.styleProvider.get()).getStyleClasses(item));
            }
            this.getStyleClass().setAll(styleClasses);
            this.booleanProperty = (ObservableValue)callback.call(item);
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().bindBidirectional((Property)((BooleanProperty)this.booleanProperty));
            }
        } else {
            this.setGraphic(null);
            this.setText(null);
        }
    }

    public static interface StyleProvider<T> {
        @Nonnull
        public List<String> getStyleClasses(T var1);
    }
}

