/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util.ui;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;

public class TextFieldWithStatus
extends TextField
implements ChangeListener<Status> {
    private final ObjectProperty<Status> status = new SimpleObjectProperty((Object)Status.NONE);
    private final ObjectProperty<String> statusDetailString = new SimpleObjectProperty((Object)"");

    public TextFieldWithStatus() {
        this.initialize();
    }

    public TextFieldWithStatus(String s) {
        super(s);
        this.initialize();
    }

    private void initialize() {
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("textfield-with-status.css").toExternalForm());
        this.status.addListener((ChangeListener)this);
        Tooltip tooltip = new Tooltip();
        this.setTooltip(tooltip);
        tooltip.textProperty().bind(this.statusDetailString);
    }

    public Status getStatus() {
        return (Status)((Object)this.status.get());
    }

    public void setStatus(Status status) {
        this.status.set((Object)status);
    }

    public ObjectProperty<Status> statusProperty() {
        return this.status;
    }

    public String getStatusDetailString() {
        return (String)this.statusDetailString.get();
    }

    public ObjectProperty<String> statusDetailStringProperty() {
        return this.statusDetailString;
    }

    public void setStatusDetailString(String statusDetailString) {
        this.statusDetailString.set((Object)statusDetailString);
    }

    public void changed(ObservableValue<? extends Status> observableValue, Status oldValue, Status newValue) {
        this.getStyleClass().remove((Object)oldValue.styleName);
        this.getStyleClass().add((Object)newValue.styleName);
    }

    public static enum Status {
        NONE("textfield-normal"),
        OK("textfield-ok"),
        WARNING("textfield-warning"),
        ERROR("textfield-error");

        private final String styleName;

        private Status(String styleName) {
            this.styleName = styleName;
        }
    }
}

