/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.util.ui;

import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class TransformingObjectBinding<S, T>
extends ObjectBinding<T> {
    private final ObjectExpression<S> source;
    private final Function<S, T> transformationFunction;

    public TransformingObjectBinding(ObjectExpression<S> source, Function<S, T> transformationFunction) {
        this.source = source;
        this.transformationFunction = transformationFunction;
        super.bind(new Observable[]{source});
    }

    protected T computeValue() {
        return this.transformationFunction.apply(this.source.get());
    }

    public void dispose() {
        super.unbind(new Observable[]{this.source});
    }

    public ObservableList<ObservableValue<?>> getDependencies() {
        return FXCollections.singletonObservableList(this.source);
    }
}

