/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import java.io.IOException;
import java.io.InputStream;

public class StreamGobbler
extends InputStream {
    private InputStream is;
    private final Object synchronizer = new Object();
    private boolean isEOF = false;
    private boolean isClosed = false;
    private IOException exception = null;
    private byte[] buffer = new byte[2048];
    private int read_pos = 0;
    private int write_pos = 0;

    public StreamGobbler(InputStream is) {
        this.is = is;
        GobblerThread t = new GobblerThread();
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        boolean wasInterrupted = false;
        try {
            Object object = this.synchronizer;
            // MONITORENTER : object
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
        }
        catch (Throwable throwable) {
            if (!wasInterrupted) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
        while (this.read_pos == this.write_pos) {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.isEOF) {
                int n = -1;
                // MONITOREXIT : object
                if (!wasInterrupted) return n;
                Thread.currentThread().interrupt();
                return n;
            }
            try {
                this.synchronizer.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        int n = this.buffer[this.read_pos++] & 0xFF;
        // MONITOREXIT : object
        if (!wasInterrupted) return n;
        Thread.currentThread().interrupt();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
            return this.write_pos - this.read_pos;
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.isEOF = true;
            this.synchronizer.notifyAll();
            this.is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0) throw new IndexOutOfBoundsException();
        if (len < 0) throw new IndexOutOfBoundsException();
        if (off + len > b.length) throw new IndexOutOfBoundsException();
        if (off + len < 0) throw new IndexOutOfBoundsException();
        if (off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        boolean wasInterrupted = false;
        try {
            Object object = this.synchronizer;
            // MONITORENTER : object
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
        }
        catch (Throwable throwable) {
            if (!wasInterrupted) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
        while (this.read_pos == this.write_pos) {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.isEOF) {
                int n = -1;
                // MONITOREXIT : object
                if (!wasInterrupted) return n;
                Thread.currentThread().interrupt();
                return n;
            }
            try {
                this.synchronizer.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        int avail = this.write_pos - this.read_pos;
        avail = avail > len ? len : avail;
        System.arraycopy(this.buffer, this.read_pos, b, off, avail);
        this.read_pos += avail;
        int n = avail;
        // MONITOREXIT : object
        if (!wasInterrupted) return n;
        Thread.currentThread().interrupt();
        return n;
    }

    static /* synthetic */ byte[] access$302(StreamGobbler x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }

    class GobblerThread
    extends Thread {
        GobblerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            byte[] buff = new byte[8192];
            try {
                while (true) {
                    int avail = StreamGobbler.this.is.read(buff);
                    Object object = StreamGobbler.this.synchronizer;
                    synchronized (object) {
                        if (avail <= 0) {
                            StreamGobbler.this.isEOF = true;
                            StreamGobbler.this.synchronizer.notifyAll();
                            return;
                        }
                        int space_available = StreamGobbler.this.buffer.length - StreamGobbler.this.write_pos;
                        if (space_available < avail) {
                            int unread_size = StreamGobbler.this.write_pos - StreamGobbler.this.read_pos;
                            int need_space = unread_size + avail;
                            byte[] new_buffer = StreamGobbler.this.buffer;
                            if (need_space > StreamGobbler.this.buffer.length) {
                                int inc = need_space / 3;
                                inc = inc < 256 ? 256 : inc;
                                inc = inc > 8192 ? 8192 : inc;
                                new_buffer = new byte[need_space + inc];
                            }
                            if (unread_size > 0) {
                                System.arraycopy(StreamGobbler.this.buffer, StreamGobbler.this.read_pos, new_buffer, 0, unread_size);
                            }
                            StreamGobbler.access$302(StreamGobbler.this, new_buffer);
                            StreamGobbler.this.read_pos = 0;
                            StreamGobbler.this.write_pos = unread_size;
                        }
                        System.arraycopy(buff, 0, StreamGobbler.this.buffer, StreamGobbler.this.write_pos, avail);
                        StreamGobbler.this.write_pos = StreamGobbler.this.write_pos + avail;
                        StreamGobbler.this.synchronizer.notifyAll();
                    }
                }
            }
            catch (IOException e) {
                Object object = StreamGobbler.this.synchronizer;
                synchronized (object) {
                    StreamGobbler.this.exception = e;
                    StreamGobbler.this.synchronizer.notifyAll();
                    return;
                }
            }
        }
    }
}

