/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.history.ApiCallHistory;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.TestClassList;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfigEditor;
import be.iminds.ilabt.jfed.testing.base.ApiTestFactory;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.AutomatedTestRunner;
import be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui.AutomatedTesterModel;
import be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui.LoadConfigFromUrlDialog;
import be.iminds.ilabt.jfed.ui.javafx.choosers.ServerChooser;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.log_gui.LogHistoryPanel;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.BooleanArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.EnumArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.IntegerArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.LongArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.MultiLineStringArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.StringArgumentChooser;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.LoggerFactory;

public class AutomatedTester {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(AutomatedTester.class);
    Task<ApiTestResult> runTask;
    @FXML
    private ServerChooser targetAuthChooserController;
    @FXML
    private Label userAuthLabel;
    @FXML
    private ListView<String> testClassesListView;
    @FXML
    private ListView<String> testGroupsListView;
    @FXML
    private Button runButton;
    @FXML
    private ScrollPane argumentsScrollPane;
    @FXML
    private TextArea rawArgumentsTextArea;
    @FXML
    private GridPane argumentsBox;
    @FXML
    private WebView webView;
    @FXML
    private Parent progressBarBox;
    @FXML
    private Label progressLabel;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private TabPane testReportTabPane;
    @FXML
    private Tab testReportTab;
    private ObservableList<String> testGroups = FXCollections.observableArrayList();
    private Class<? extends ApiTest> testClass;
    private Map<ApiTestConfigEditor.ApiTestConfigParameter, CommandArgumentChooser> extraArguments = new HashMap<ApiTestConfigEditor.ApiTestConfigParameter, CommandArgumentChooser>();
    private Map<ApiTestConfigEditor.ApiTestConfigParameter, CheckBox> extraArgumentsNullBoxes = new HashMap<ApiTestConfigEditor.ApiTestConfigParameter, CheckBox>();
    private Stage historyStage;
    private final GeniUserProvider geniUserProvider;
    private final ApiCallHistory apiCallHistory;
    private final TestbedInfoSource testbedInfoSource;
    private final Logger logger;
    private final Provider<LogHistoryPanel> logHistoryPanelProvider;
    private final JFedHLPreferences jFedPreferences;
    private final ApiTestFactory apiTestFactory;
    private final SerializableApiCallDetailsFactory serializableApiCallDetailsFactory;
    private final Provider<LoadConfigFromUrlDialog> loadConfigFromUrlDialogProvider;
    private ApiTestMetaData apiTestMetaData;
    private ApiTestConfigEditor configEditor;
    private AutomatedTesterModel model;
    private String shownHtmlOutput = null;
    private ApiTestResult shownResult = null;
    private File AUTOMATED_TESTER_STORED_ARGUMENTS_FILE = new File(JFedUtils.getUserDataDirectoryFile(), "saved_automated_tester_arguments");

    @Inject
    public AutomatedTester(GeniUserProvider geniUserProvider, ApiCallHistory apiCallHistory, TestbedInfoSource testbedInfoSource, Logger logger, Provider<LogHistoryPanel> logHistoryPanelProvider, JFedHLPreferences jFedPreferences, ApiTestFactory apiTestFactory, SerializableApiCallDetailsFactory serializableApiCallDetailsFactory, Provider<LoadConfigFromUrlDialog> loadConfigFromUrlDialogProvider) {
        this.geniUserProvider = geniUserProvider;
        this.apiCallHistory = apiCallHistory;
        this.testbedInfoSource = testbedInfoSource;
        this.logger = logger;
        this.logHistoryPanelProvider = logHistoryPanelProvider;
        this.jFedPreferences = jFedPreferences;
        this.apiTestFactory = apiTestFactory;
        this.serializableApiCallDetailsFactory = serializableApiCallDetailsFactory;
        this.loadConfigFromUrlDialogProvider = loadConfigFromUrlDialogProvider;
    }

    @FXML
    private void initialize() {
        ObservableList testClasses = FXCollections.observableArrayList(AutomatedTester.allTestClasses());
        this.testClassesListView.setItems(testClasses);
        this.testGroupsListView.setItems(this.testGroups);
        this.model = new AutomatedTesterModel((SelectionModel<String>)this.testClassesListView.getSelectionModel(), (SelectionModel<String>)this.testGroupsListView.getSelectionModel(), this.targetAuthChooserController, (BooleanProperty)new SimpleBooleanProperty(false));
        this.model.selectedClassNameProperty().addListener((observableValue, oldSelectedItem, newSelectedItem) -> this.updateSelectedClass((String)newSelectedItem));
        this.progressBarBox.managedProperty().bind((ObservableValue)this.progressBarBox.visibleProperty());
        this.progressBarBox.setVisible(false);
        this.model.restore();
        this.updateSelectedClass(this.model.getSelectedClassName());
        this.rawArgumentsTextArea.visibleProperty().bind((ObservableValue)this.model.showRawModelProperty());
        this.argumentsScrollPane.visibleProperty().bind((ObservableValue)this.model.showRawModelProperty().not());
        LOG.debug("at start showRaw=" + this.model.showRawModelProperty().getValue());
        assert (this.testReportTabPane != null);
        assert (this.testReportTab != null);
    }

    public void loadConfigFromUrl() {
        LoadConfigFromUrlDialog dialog = (LoadConfigFromUrlDialog)((Object)this.loadConfigFromUrlDialogProvider.get());
        dialog.showAndWait().ifPresent(config -> {
            String configString;
            this.model.setSelectedClassName(config.getTestClassName());
            this.testGroupsListView.getSelectionModel().select((Object)config.getTestGroup());
            if (config.getServerId() != null) {
                this.targetAuthChooserController.select(config.getServerId().intValue());
            }
            if ((configString = config.getConfig()) != null) {
                this.rawArgumentsTextArea.setText(configString);
                this.loadArgumentsFromString(configString);
            } else {
                this.rawArgumentsTextArea.setText("");
                this.loadArgumentsFromString("");
            }
        });
    }

    public static List<String> allTestClasses() {
        return TestClassList.getInstance().allTestClasses();
    }

    public void updateSelectedClass(String selectedClassName) {
        if (selectedClassName == null) {
            this.testClass = null;
            this.testGroups.clear();
            return;
        }
        this.testClass = null;
        try {
            this.testClass = Class.forName(selectedClassName).asSubclass(ApiTest.class);
            assert (ApiTest.class.isAssignableFrom(this.testClass)) : this.testClass.getName() + " is not a ApiTest class";
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bug in Test GUI: could not find test class " + selectedClassName, e);
        }
        assert (this.testClass != null);
        this.testGroups.setAll(this.testGroups(this.testClass));
        this.apiTestMetaData = ApiTest.getMetaData(this.testClass);
        this.configEditor = this.apiTestMetaData.getApiTestConfigEditor();
        List parameters = this.configEditor.getParameters();
        this.extraArguments.clear();
        this.extraArgumentsNullBoxes.clear();
        this.argumentsBox.getChildren().clear();
        int row = 0;
        if (!parameters.isEmpty()) {
            Label head = new Label("Extra Test Arguments: ");
            VBox.setMargin((Node)head, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
            this.argumentsBox.getChildren().add((Object)head);
            for (ApiTestConfigEditor.ApiTestConfigParameter parameter : parameters) {
                MultiLineStringArgumentChooser commandArgumentChooser;
                Object defaultValue;
                System.out.println("Parameter=" + String.valueOf(parameter));
                String key = parameter.getName().stream().collect(Collectors.joining("."));
                boolean required = parameter.isAllowNull();
                Object commandArgumentChooser_helper = null;
                if (parameter.getType().equals(String.class)) {
                    defaultValue = parameter.getDefaultValue() == null ? "" : String.valueOf(parameter.getDefaultValue());
                    commandArgumentChooser_helper = key.equals("fixed_rspec") || key.trim().toLowerCase().endsWith("credential") ? new MultiLineStringArgumentChooser((String)defaultValue, true) : new StringArgumentChooser((String)defaultValue);
                }
                if (parameter.getType().equals(Boolean.class) || parameter.getType().equals(Boolean.TYPE)) {
                    defaultValue = parameter.getDefaultValue() == null ? false : (Boolean)parameter.getDefaultValue();
                    commandArgumentChooser_helper = new BooleanArgumentChooser((Boolean)defaultValue);
                }
                if (parameter.getType().equals(Integer.class) || parameter.getType().equals(Integer.TYPE)) {
                    defaultValue = parameter.getDefaultValue() == null ? 0 : (Integer)parameter.getDefaultValue();
                    commandArgumentChooser_helper = new IntegerArgumentChooser((Integer)defaultValue);
                }
                if (parameter.getType().equals(Long.class) || parameter.getType().equals(Long.TYPE)) {
                    defaultValue = parameter.getDefaultValue() == null ? 0L : (Long)parameter.getDefaultValue();
                    commandArgumentChooser_helper = new LongArgumentChooser((Long)defaultValue);
                }
                if (parameter.getType().isEnum()) {
                    defaultValue = parameter.getDefaultValue() == null ? null : (Enum)parameter.getDefaultValue();
                    commandArgumentChooser_helper = new EnumArgumentChooser(parameter.getType(), (Enum)defaultValue);
                }
                if ((commandArgumentChooser = commandArgumentChooser_helper) == null) {
                    LOG.warn("Cannot show edit for option " + String.valueOf(parameter.getName()) + " of type " + parameter.getType().getName());
                    continue;
                }
                if (parameter.isAllowNull()) {
                    CheckBox nullBox = new CheckBox("");
                    GridPane.setRowIndex((Node)nullBox, (Integer)row);
                    GridPane.setColumnIndex((Node)nullBox, (Integer)0);
                    this.argumentsBox.getChildren().add((Object)nullBox);
                    nullBox.setSelected(parameter.getDefaultValue() != null);
                    this.extraArgumentsNullBoxes.put(parameter, nullBox);
                    commandArgumentChooser.disableProperty().bind((ObservableValue)nullBox.selectedProperty().not());
                }
                Label parameterLabel = new Label(key + ":");
                GridPane.setRowIndex((Node)parameterLabel, (Integer)row);
                GridPane.setColumnIndex((Node)parameterLabel, (Integer)1);
                this.argumentsBox.getChildren().add((Object)parameterLabel);
                HBox hBox = new HBox();
                HBox.setMargin((Node)parameterLabel, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
                HBox.setHgrow((Node)commandArgumentChooser, (Priority)Priority.ALWAYS);
                hBox.getChildren().addAll((Object[])new Node[]{commandArgumentChooser});
                VBox.setMargin((Node)hBox, (Insets)new Insets(10.0, 0.0, 0.0, 10.0));
                GridPane.setRowIndex((Node)hBox, (Integer)row);
                GridPane.setColumnIndex((Node)hBox, (Integer)2);
                GridPane.setColumnSpan((Node)hBox, (Integer)2);
                this.argumentsBox.getChildren().add((Object)hBox);
                if (key.endsWith("_file")) {
                    Button b = new Button("Choose File...");
                    hBox.getChildren().add((Object)b);
                    b.setOnAction(arg_0 -> this.lambda$updateSelectedClass$2((CommandArgumentChooser)commandArgumentChooser, arg_0));
                }
                ++row;
                this.extraArguments.put(parameter, (CommandArgumentChooser)commandArgumentChooser);
            }
        }
        if (this.runTask == null) {
            this.progressBarBox.setVisible(false);
        }
    }

    public List<String> testGroups(Class<? extends ApiTest> testClass) {
        List<String> res = Arrays.stream(testClass.getMethods()).flatMap(m -> Arrays.stream(m.getDeclaredAnnotations())).filter(annotation -> annotation instanceof ApiTest.Test).map(ApiTest.Test.class::cast).flatMap(testAnnotation -> Arrays.stream(testAnnotation.groups())).distinct().collect(Collectors.toList());
        res.add("<no group>");
        return res;
    }

    @FXML
    private void runTests() {
        if (this.runTask == null) {
            this.progressBarBox.setVisible(false);
        }
        if (this.runTask != null) {
            JFDialogs.create().owner(this.runButton.getScene().getWindow()).message("Already running tests. Wait until current tests are finished.").showError();
            return;
        }
        if (!this.geniUserProvider.isUserLoggedIn()) {
            JFDialogs.create().owner(this.runButton.getScene().getWindow()).message("Can only run tests if user is logged in: log in first").showError();
            return;
        }
        if (this.targetAuthChooserController.getSelectedServer() == null) {
            JFDialogs.create().owner(this.runButton.getScene().getWindow()).message("No target authority is selected").showError();
            return;
        }
        if (this.model.getSelectedClassName() == null || this.testClass == null) {
            JFDialogs.create().owner(this.runButton.getScene().getWindow()).message("No test is selected").showError();
            return;
        }
        assert (this.testClass != null);
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        Server authForRspec = this.targetAuthChooserController.getSelectedServer();
        Server authToConnect = this.targetAuthChooserController.getSelectedServer();
        final TargetAuthority testedAuthority = new TargetAuthority(this.targetAuthChooserController.getSelectedServer().getDefaultComponentManagerAsGeniUrn(), authForRspec, authToConnect);
        String group = this.model.getSelectedTestGroup();
        if (Objects.equals(group, "<no group>")) {
            group = null;
        }
        final String testGroup = group;
        final String configString = this.getCurrentConfigString();
        LOG.debug("Running Test: {} group={}", (Object)this.testClass.getName(), (Object)group);
        this.runTask = new Task<ApiTestResult>(){

            protected ApiTestResult call() throws Exception {
                LOG.debug("   Starting Tests");
                this.updateMessage("Starting Tests");
                this.updateProgress(0L, 100L);
                try {
                    Platform.runLater(() -> {
                        assert (AutomatedTester.this.testReportTabPane != null);
                        assert (AutomatedTester.this.testReportTab != null);
                        AutomatedTester.this.testReportTabPane.getTabs().retainAll((Object[])new Tab[]{AutomatedTester.this.testReportTab});
                        AutomatedTester.this.shownResult = null;
                        AutomatedTester.this.shownHtmlOutput = null;
                        WebEngine webEngine = AutomatedTester.this.webView.getEngine();
                        webEngine.loadContent("<html><body><p>Running test...</p></body></html>");
                    });
                    ApiTest test = AutomatedTester.this.apiTestFactory.createApiTest(AutomatedTester.this.logger, testedAuthority, AutomatedTester.this.testClass, configString);
                    AutomatedTestRunner automatedTestRunner = new AutomatedTestRunner(testedAuthority, AutomatedTester.this.serializableApiCallDetailsFactory);
                    AutomatedTester.this.shownResult = automatedTestRunner.runTest(test, testGroup, new AutomatedTestRunner.TestListener(){

                        public void onStart(String testname, int testNr, int testCount) {
                            LOG.debug("Running test: {} ...", (Object)testname);
                            this.updateMessage("Running test: " + testname);
                            this.updateProgress(testNr - 1, testCount);
                        }

                        public void onResult(ApiTestResult.ApiTestMethodResult result, int testNr, int testCount) {
                            LOG.debug("     Test result: {}", (Object)result);
                            this.updateProgress(testNr, testCount);
                        }

                        public void onAllTestDone(ApiTestResult result, int testCount) {
                            this.updateProgress(testCount, testCount);
                            this.updateMessage("All tests completed");
                        }
                    }, false);
                    this.updateMessage("Test Finished. Generating HTML report...");
                    LOG.debug("Test Finished. Generating HTML report...");
                    try {
                        AutomatedTester.this.shownHtmlOutput = AutomatedTester.this.shownResult.toHtmlString(true, true);
                    }
                    catch (AssertionError | Exception e) {
                        LOG.error("Error while generating HTML: ", (Throwable)e);
                        AutomatedTester.this.shownHtmlOutput = "Error while generating HTML: " + ((Throwable)e).getMessage();
                    }
                    this.updateMessage("Test Finished. HTML report created.");
                    LOG.debug("Test Finished. HTML report created.");
                    Platform.runLater(() -> {
                        WebEngine webEngine = AutomatedTester.this.webView.getEngine();
                        webEngine.loadContent(AutomatedTester.this.shownHtmlOutput, "text/html");
                        LOG.debug("   Showing test");
                    });
                    for (ApiTestResult.ApiTestMethodResult testMethodResult : AutomatedTester.this.shownResult.getResultList()) {
                        for (ApiTestResult.ApiTestMethodResult.FedmonResultExtra extra : testMethodResult.getFedmonResultExtras()) {
                            TextArea extraTextArea = new TextArea();
                            extraTextArea.setEditable(false);
                            extraTextArea.setText(String.valueOf(extra.getValue()));
                            Tab extraTab = new Tab(extra.getNestedKey().stream().collect(Collectors.joining(".")));
                            extraTab.setContent((Node)extraTextArea);
                            Platform.runLater(() -> AutomatedTester.this.testReportTabPane.getTabs().add((Object)extraTab));
                        }
                    }
                    AutomatedTester.this.runTask = null;
                    return AutomatedTester.this.shownResult;
                }
                catch (AssertionError e) {
                    LOG.error("Something went wrong while running tests: " + String.valueOf(e), (Throwable)((Object)e));
                    this.updateMessage("AssertionError has occured while running test.");
                    AutomatedTester.this.runTask = null;
                    return null;
                }
                catch (Exception e) {
                    LOG.error("Something went wrong while running tests: " + String.valueOf(e), (Throwable)e);
                    this.updateMessage("Exception has occured while running test.");
                    AutomatedTester.this.runTask = null;
                    return null;
                }
            }
        };
        this.progressBar.progressProperty().bind((ObservableValue)this.runTask.progressProperty());
        this.progressLabel.textProperty().bind((ObservableValue)this.runTask.messageProperty());
        this.progressBarBox.setVisible(true);
        new Thread((Runnable)this.runTask).start();
    }

    private void saveCurrentConfigToEditor() {
        for (Map.Entry<ApiTestConfigEditor.ApiTestConfigParameter, CommandArgumentChooser> e : this.extraArguments.entrySet()) {
            ApiTestConfigEditor.ApiTestConfigParameter parameter = e.getKey();
            CommandArgumentChooser chooser = e.getValue();
            CheckBox nullBox = this.extraArgumentsNullBoxes.get(parameter);
            if (nullBox != null && !nullBox.isSelected()) {
                this.configEditor.setParameter(parameter, null);
                continue;
            }
            if (chooser.valueProperty() == null || chooser.valueProperty().getValue() == null) continue;
            if (chooser.valueProperty().getValue() instanceof String) {
                if (Objects.equals(((String)chooser.valueProperty().getValue()).trim(), "")) continue;
                this.configEditor.setParameter(parameter, chooser.valueProperty().getValue());
                continue;
            }
            this.configEditor.setParameter(parameter, chooser.valueProperty().getValue());
        }
    }

    private String getCurrentConfigString() {
        if (this.rawArgumentsTextArea.isVisible()) {
            return this.rawArgumentsTextArea.getText();
        }
        this.saveCurrentConfigToEditor();
        return this.configEditor.build().stringValue();
    }

    public void saveHtml() {
        if (this.shownHtmlOutput == null) {
            return;
        }
        FileChooser fc = new FileChooser();
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        fc.setInitialFileName("result-" + this.testClass.getName() + ".html");
        File file = fc.showSaveDialog(null);
        if (file == null) {
            return;
        }
        try {
            IOUtils.stringToFile((File)file, (String)this.shownHtmlOutput);
        }
        catch (Exception e) {
            LOG.error("Error while writing HTML to file: ", (Throwable)e);
            throw e;
        }
    }

    public void saveXml() {
        if (this.shownResult == null) {
            return;
        }
        FileChooser fc = new FileChooser();
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        fc.setInitialFileName("result-overview-" + this.testClass.getName() + ".xml");
        File file = fc.showSaveDialog(null);
        if (file == null) {
            return;
        }
        try {
            this.shownResult.toXmlOverview(file, true);
        }
        catch (Exception e) {
            LOG.error("Error while generating XML overview: ", (Throwable)e);
            throw e;
        }
    }

    @FXML
    private void showLogHistory() {
        if (this.historyStage == null) {
            try {
                LogHistoryPanel logHistoryPanel = (LogHistoryPanel)this.logHistoryPanelProvider.get();
                logHistoryPanel.setApiCallHistory(this.apiCallHistory);
                this.historyStage = new Stage();
                this.historyStage.setTitle("Call Log History");
                Scene scene = new Scene((Parent)logHistoryPanel);
                this.historyStage.setScene(scene);
                this.historyStage.setWidth(800.0);
                this.historyStage.setHeight(600.0);
            }
            catch (Exception e) {
                LOG.error("Error while loading Call Log History window", (Throwable)e);
            }
        }
        assert (this.historyStage != null);
        this.historyStage.show();
    }

    public void resetArguments() {
        for (Map.Entry<ApiTestConfigEditor.ApiTestConfigParameter, CommandArgumentChooser> e : this.extraArguments.entrySet()) {
            Object defaultValue;
            ApiTestConfigEditor.ApiTestConfigParameter parameter = e.getKey();
            CommandArgumentChooser chooser = e.getValue();
            CheckBox nullBox = this.extraArgumentsNullBoxes.get(parameter);
            if (nullBox != null) {
                nullBox.setSelected(parameter.getDefaultValue() != null);
            }
            if (chooser instanceof StringArgumentChooser || chooser instanceof MultiLineStringArgumentChooser) {
                Object object = defaultValue = parameter.getDefaultValue() == null ? "" : String.valueOf(parameter.getDefaultValue());
                if (chooser instanceof StringArgumentChooser) {
                    ((StringArgumentChooser)chooser).setValue((String)defaultValue);
                }
                if (chooser instanceof MultiLineStringArgumentChooser) {
                    ((MultiLineStringArgumentChooser)chooser).setValue((String)defaultValue);
                }
            }
            if (chooser instanceof BooleanArgumentChooser) {
                defaultValue = parameter.getDefaultValue() == null ? false : (Boolean)parameter.getDefaultValue();
                ((BooleanArgumentChooser)chooser).setValue((Boolean)defaultValue);
            }
            if (!(chooser instanceof IntegerArgumentChooser)) continue;
            defaultValue = parameter.getDefaultValue() == null ? 0 : (Integer)parameter.getDefaultValue();
            ((IntegerArgumentChooser)chooser).setValue((Integer)defaultValue);
        }
    }

    public void saveArguments() throws IOException {
        FileWriter w = new FileWriter(this.AUTOMATED_TESTER_STORED_ARGUMENTS_FILE);
        w.write(this.getCurrentConfigString());
        w.close();
    }

    public void loadArguments() throws IOException {
        String configString = IOUtils.fileToString((File)this.AUTOMATED_TESTER_STORED_ARGUMENTS_FILE);
        this.rawArgumentsTextArea.setText(configString);
        this.loadArgumentsFromString(configString);
    }

    public void loadArgumentsFromString(String configString) {
        ApiTestConfig apiTestConfig = this.apiTestMetaData.parseApiTestConfig(configString);
        this.configEditor.setConfig(apiTestConfig);
        for (Map.Entry<ApiTestConfigEditor.ApiTestConfigParameter, CommandArgumentChooser> e : this.extraArguments.entrySet()) {
            CommandArgumentChooser chooser;
            ApiTestConfigEditor.ApiTestConfigParameter parameter = e.getKey();
            CheckBox nullBox = this.extraArgumentsNullBoxes.get(parameter);
            Object newValue = this.configEditor.getParameter(parameter);
            if (nullBox != null) {
                nullBox.setSelected(newValue != null);
            }
            if ((chooser = e.getValue()) instanceof StringArgumentChooser) {
                if (newValue == null) {
                    newValue = "";
                }
                ((StringArgumentChooser)chooser).setValue(String.valueOf(newValue));
            }
            if (chooser instanceof MultiLineStringArgumentChooser) {
                if (newValue == null) {
                    newValue = "";
                }
                ((MultiLineStringArgumentChooser)chooser).setValue(String.valueOf(newValue));
            }
            if (chooser instanceof IntegerArgumentChooser && newValue instanceof Integer) {
                ((IntegerArgumentChooser)chooser).setValue((Integer)newValue);
            }
            if (chooser instanceof LongArgumentChooser && newValue instanceof Long) {
                ((LongArgumentChooser)chooser).setValue((Long)newValue);
            }
            if (chooser instanceof BooleanArgumentChooser && newValue instanceof Boolean) {
                ((BooleanArgumentChooser)chooser).setValue((Boolean)newValue);
            }
            if (!(chooser instanceof EnumArgumentChooser) || !(newValue instanceof String)) continue;
            ((EnumArgumentChooser)chooser).setStringValue((String)newValue);
        }
    }

    @FXML
    public void swapRaw() {
        boolean showRaw = this.model.toggleShowRaw();
        LOG.debug("New showRaw=" + showRaw);
        if (showRaw) {
            this.rawArgumentsTextArea.setText(this.getCurrentConfigString());
        } else {
            this.loadArgumentsFromString(this.rawArgumentsTextArea.getText());
        }
    }

    private /* synthetic */ void lambda$updateSelectedClass$2(CommandArgumentChooser commandArgumentChooser, ActionEvent actionEvent) {
        File file;
        File dir;
        FileChooser fc = new FileChooser();
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST) && (dir = new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST))).exists()) {
            fc.setInitialDirectory(dir);
        }
        if ((file = fc.showOpenDialog(null)) == null) {
            return;
        }
        ((StringArgumentChooser)commandArgumentChooser).setValue(file.getAbsolutePath());
    }
}

