/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.ui.javafx.choosers.ServerChooser;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import java.io.File;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.control.SelectionModel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatedTesterModel {
    private static final Logger LOG = LoggerFactory.getLogger(AutomatedTesterModel.class);
    @Nonnull
    private final SelectionModel<String> classNameSelectionModel;
    @Nonnull
    private final SelectionModel<String> testGroupSelectionModel;
    @Nonnull
    private final ServerChooser serverChooser;
    @Nonnull
    private final BooleanProperty showRawModel;
    @Nullable
    private final File propertiesFile;
    private boolean autosaveEnabled = false;
    private PropertiesConfiguration cachedConf = null;

    public AutomatedTesterModel(@Nonnull SelectionModel<String> classNameSelectionModel, @Nonnull SelectionModel<String> testGroupSelectionModel, @Nonnull ServerChooser serverChooser, @Nonnull BooleanProperty showRawModel) {
        this.classNameSelectionModel = classNameSelectionModel;
        this.testGroupSelectionModel = testGroupSelectionModel;
        this.serverChooser = serverChooser;
        this.showRawModel = showRawModel;
        classNameSelectionModel.selectedItemProperty().addListener((p, o, n) -> this.autoSave());
        testGroupSelectionModel.selectedItemProperty().addListener((p, o, n) -> this.autoSave());
        serverChooser.selectedAuthorityProperty().addListener((p, o, n) -> this.autoSave());
        showRawModel.addListener((p, o, n) -> this.autoSave());
        this.propertiesFile = JFedUtils.createPreferencesFile((String)"automated-tester.properties");
    }

    private PropertiesConfiguration getPropertiesConfiguration() {
        PropertiesConfiguration conf;
        if (this.cachedConf != null) {
            return this.cachedConf;
        }
        if (this.propertiesFile == null) {
            System.err.println("Cannot load AutomatedTester properties");
            return null;
        }
        try {
            conf = new PropertiesConfiguration(this.propertiesFile);
        }
        catch (ConfigurationException e) {
            System.err.println("Cannot restore AutomatedTester properties: " + e.getMessage());
            LOG.error("Error restoring AutomatedTester config", (Throwable)e);
            return null;
        }
        conf.setThrowExceptionOnMissing(false);
        this.cachedConf = conf;
        return conf;
    }

    public void restore() {
        String className;
        this.autosaveEnabled = false;
        PropertiesConfiguration conf = this.getPropertiesConfiguration();
        if (conf == null) {
            return;
        }
        Integer serverId = conf.getInteger("server_id", null);
        if (serverId != null) {
            this.serverChooser.select(serverId.intValue());
        }
        if ((className = conf.getString("class_name", null)) == null) {
            this.classNameSelectionModel.clearSelection();
        } else {
            this.classNameSelectionModel.select((Object)className);
        }
        String testGroup = conf.getString("test_group", null);
        if (testGroup == null) {
            this.testGroupSelectionModel.clearSelection();
        } else {
            this.testGroupSelectionModel.select((Object)testGroup);
        }
        boolean showRaw = conf.getBoolean("show_raw", false);
        this.showRawModel.setValue(Boolean.valueOf(showRaw));
        this.autosaveEnabled = true;
    }

    public void autoSave() {
        if (this.autosaveEnabled) {
            this.save();
        }
    }

    public void save() {
        PropertiesConfiguration conf = this.getPropertiesConfiguration();
        if (conf == null) {
            return;
        }
        if (this.classNameSelectionModel.isEmpty()) {
            conf.clearProperty("class_name");
        } else {
            conf.setProperty("class_name", this.classNameSelectionModel.getSelectedItem());
        }
        if (this.testGroupSelectionModel.isEmpty()) {
            conf.clearProperty("test_group");
        } else {
            conf.setProperty("test_group", this.testGroupSelectionModel.getSelectedItem());
        }
        if (this.serverChooser.getSelectedServer() == null) {
            conf.clearProperty("server_id");
        } else {
            conf.setProperty("server_id", this.serverChooser.getSelectedServer().getId());
        }
        conf.setProperty("show_raw", (Object)this.showRawModel.get());
        try {
            conf.save();
        }
        catch (ConfigurationException e) {
            System.err.println("Cannot saving AutomatedTester properties: " + e.getMessage());
            LOG.error("Error saving AutomatedTester config", (Throwable)e);
        }
    }

    public String getSelectedClassName() {
        return (String)this.classNameSelectionModel.selectedItemProperty().get();
    }

    public ReadOnlyObjectProperty<String> selectedClassNameProperty() {
        return this.classNameSelectionModel.selectedItemProperty();
    }

    public void setSelectedClassName(String selectedClassName) {
        this.classNameSelectionModel.select((Object)selectedClassName);
    }

    public String getSelectedTestGroup() {
        return (String)this.testGroupSelectionModel.selectedItemProperty().get();
    }

    public ReadOnlyObjectProperty<String> selectedTestGroupProperty() {
        return this.testGroupSelectionModel.selectedItemProperty();
    }

    public void setSelectedTestGroup(String selectedTestGroup) {
        this.testGroupSelectionModel.select((Object)selectedTestGroup);
    }

    public Server getSelectedServer() {
        return (Server)this.serverChooser.selectedAuthorityProperty().get();
    }

    public Integer getSelectedServerId() {
        Server res = this.getSelectedServer();
        if (res == null) {
            return null;
        }
        return (Integer)res.getId();
    }

    public ReadOnlyObjectProperty<Server> selectedSelectedServerProperty() {
        return this.serverChooser.selectedAuthorityProperty();
    }

    public void setSelectedServer(Server server) {
        this.serverChooser.select(server);
    }

    public void setSelectedServer(int serverId) {
        this.serverChooser.select(serverId);
    }

    @Nonnull
    public boolean isShowRawModel() {
        return this.showRawModel.get();
    }

    @Nonnull
    public BooleanProperty showRawModelProperty() {
        return this.showRawModel;
    }

    public boolean toggleShowRaw() {
        boolean newValue = !this.showRawModel.get();
        this.showRawModel.setValue(Boolean.valueOf(newValue));
        return newValue;
    }
}

