/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui;

import be.iminds.ilabt.jfed.base_gui.BaseGuiModule;
import be.iminds.ilabt.jfed.base_gui.UncaughtGuiExceptionLogger;
import be.iminds.ilabt.jfed.base_gui.util.GuiceContext;
import be.iminds.ilabt.jfed.highlevel.HighLevelModule;
import be.iminds.ilabt.jfed.highlevel.LowLevelModule;
import be.iminds.ilabt.jfed.highlevel.SfaOnlyExperimentModule;
import be.iminds.ilabt.jfed.highlevel.UserLoginModelModule;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ssh_terminal_tool.unix.SshAgentHelper;
import be.iminds.ilabt.jfed.ui.javafx.userlogin.AdvancedUserLoginDialog;
import java.io.IOException;
import java.security.Security;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatedTesterStandalone
extends Application
implements GeniUserProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AutomatedTesterStandalone.class);
    private static final String AUTOMATED_TESTER_FXML = "AutomatedTester.fxml";
    public static boolean debugEnabled = false;
    private final GuiceContext context = new GuiceContext((Object)this, () -> {
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.add(new LowLevelModule());
        modules.add(new HighLevelModule());
        modules.add(new SfaOnlyExperimentModule());
        modules.add(new UserLoginModelModule(true));
        modules.add(new BaseGuiModule());
        modules.add(binder -> binder.bind(GeniUserProvider.class).toInstance((Object)this));
        return modules;
    });
    @Inject
    private Provider<AdvancedUserLoginDialog> advancedUserLoginDialogProvider;
    @Inject
    private FXMLLoader loader;
    @Inject
    private TaskThread tt;
    private GeniUser loggedInUser;

    public static void main(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("debug") && !arg.equalsIgnoreCase("--debug") && !arg.equalsIgnoreCase("-debug")) continue;
            debugEnabled = true;
        }
        AutomatedTesterStandalone.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)UncaughtGuiExceptionLogger.getInstance((Stage)stage));
        this.context.init();
        this.loggedInUser = ((AdvancedUserLoginDialog)this.advancedUserLoginDialogProvider.get()).showUserLogin((Window)stage);
        if (this.isUserLoggedIn()) {
            this.showAutomatedTester(stage);
        } else {
            this.exit();
        }
    }

    private void showAutomatedTester(Stage stage) {
        stage.setTitle("jFed Automated Tester");
        try {
            this.loader.setLocation(AutomatedTesterStandalone.class.getResource(AUTOMATED_TESTER_FXML));
            stage.setScene(new Scene((Parent)this.loader.load()));
            stage.setOnCloseRequest(event -> this.exit());
            stage.show();
        }
        catch (IOException e) {
            LOG.error("Error while loading jFed Automated Tester", (Throwable)e);
        }
    }

    public void exit() {
        LOG.info("Close was requested. Trying to terminate");
        this.tt.requestStop();
        try {
            SshAgentHelper.stopSshAgent();
        }
        catch (SshAgentHelper.SshAgentHelperException e) {
            LOG.error("Failed to stop SSH agent. Will ignore this and continue jFed shutdown.", (Throwable)e);
        }
        Platform.exit();
        System.exit(0);
    }

    @Nonnull
    public GeniUser getLoggedInGeniUser() {
        return this.loggedInUser;
    }

    public boolean isUserLoggedIn() {
        return this.loggedInUser != null;
    }

    static {
        Security.setProperty("jdk.tls.disabledAlgorithms", "SSLv3, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL");
    }
}

